/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.vfs.internal;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.xwiki.container.Container;
import org.xwiki.container.Response;
import org.xwiki.resource.AbstractResourceReferenceHandler;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.ResourceType;
import org.xwiki.tika.internal.TikaUtils;

public abstract class AbstractContentResourceReferenceHandler
extends AbstractResourceReferenceHandler<ResourceType> {
    @Inject
    private Container container;

    protected void serveResource(String resourceName, InputStream resourceStream) throws ResourceReferenceHandlerException {
        BufferedInputStream markResetSupportingStream = new BufferedInputStream(resourceStream);
        try {
            Response response = this.container.getResponse();
            response.setContentType(TikaUtils.detect((InputStream)markResetSupportingStream, (String)resourceName));
            IOUtils.copy((InputStream)markResetSupportingStream, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new ResourceReferenceHandlerException(String.format("Failed to read resource [%s]", resourceName), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)markResetSupportingStream);
        }
    }
}

