/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.vfs.internal;

import java.net.URI;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.SerializeResourceReferenceException;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.URLNormalizer;
import org.xwiki.vfs.VfsResourceReference;

public abstract class AbstractVfsResourceReferenceSerializer
implements ResourceReferenceSerializer<VfsResourceReference, ExtendedURL> {
    @Inject
    @Named(value="contextpath")
    private URLNormalizer<ExtendedURL> extendedURLNormalizer;

    public ExtendedURL serialize(VfsResourceReference resourceReference) throws SerializeResourceReferenceException, UnsupportedResourceReferenceException {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add("vfs");
        segments.add(this.makeAbsolute(resourceReference.getURI()).toString());
        segments.addAll(resourceReference.getPathSegments());
        ExtendedURL extendedURL = new ExtendedURL(segments, resourceReference.getParameters());
        return (ExtendedURL)this.extendedURLNormalizer.normalize(extendedURL);
    }

    protected abstract URI makeAbsolute(URI var1);
}

