/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.vfs.internal.attach;

import com.xpn.xwiki.doc.XWikiAttachment;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputSocket;
import net.java.truecommons.cio.IoBufferPool;
import net.java.truecommons.cio.IoEntry;
import net.java.truecommons.cio.OutputSocket;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.kernel.spec.FsAbstractNode;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsAccessOptions;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsReadOnlyFileSystemException;
import net.java.truevfs.kernel.spec.sl.IoBufferPoolLocator;
import org.xwiki.vfs.internal.attach.AttachController;
import org.xwiki.vfs.internal.attach.AttachInputSocket;
import org.xwiki.vfs.internal.attach.AttachOutputSocket;
import org.xwiki.vfs.internal.attach.XWikiModelNode;

@Immutable
public class AttachNode
extends FsAbstractNode
implements IoEntry<AttachNode> {
    private final URI uri;
    private final AttachController controller;
    private final String name;
    private XWikiModelNode xwikiModelNode;

    AttachNode(AttachController controller, FsNodeName name) {
        assert (null != controller);
        this.controller = controller;
        this.name = name.toString();
        this.uri = controller.resolve(name).getUri();
        this.xwikiModelNode = new XWikiModelNode(controller, name);
    }

    IoBufferPool getPool() {
        return IoBufferPoolLocator.SINGLETON.get();
    }

    protected InputStream newInputStream() throws IOException {
        try {
            return this.xwikiModelNode.getAttachment().getContentInputStream(this.xwikiModelNode.getXWikiContext());
        }
        catch (Exception e) {
            throw new IOException(String.format("Failed to get attachment content for attachment [%s] in URI [%s]", this.name, this.uri), e);
        }
    }

    protected OutputStream newOutputStream() throws IOException {
        throw new FsReadOnlyFileSystemException(this.controller.getMountPoint());
    }

    public String getName() {
        return this.name;
    }

    public BitField<Entry.Type> getTypes() {
        return this.xwikiModelNode.hasAttachment() ? FILE_TYPE : NO_TYPES;
    }

    public boolean isType(Entry.Type type) {
        return type == Entry.Type.FILE && this.getTypes().is((Enum)Entry.Type.FILE);
    }

    public long getSize(Entry.Size type) {
        if (Entry.Size.DATA != type) {
            return -1L;
        }
        try {
            XWikiAttachment attachment = this.xwikiModelNode.getAttachment();
            return attachment.getContentLongSize(this.xwikiModelNode.getXWikiContext());
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public long getTime(Entry.Access type) {
        if (Entry.Access.WRITE != type) {
            return -1L;
        }
        try {
            XWikiAttachment attachment = this.xwikiModelNode.getAttachment();
            return attachment.getDate().getTime();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public Boolean isPermitted(Entry.Access type, Entry.Entity entity) {
        if (Entry.Access.READ != type) {
            return null;
        }
        return true;
    }

    public Set<String> getMembers() {
        return null;
    }

    public final InputSocket<AttachNode> input() {
        return this.input((BitField<FsAccessOption>)FsAccessOptions.NONE);
    }

    protected InputSocket<AttachNode> input(BitField<FsAccessOption> options) {
        return new AttachInputSocket(options, this);
    }

    public final OutputSocket<AttachNode> output() {
        return this.output((BitField<FsAccessOption>)FsAccessOptions.NONE, null);
    }

    protected OutputSocket<AttachNode> output(BitField<FsAccessOption> options, Entry template) {
        return new AttachOutputSocket(options, this, template);
    }
}

