/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.vfs.internal.attach;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.AttachmentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.vfs.VfsException;
import org.xwiki.vfs.VfsPermissionChecker;
import org.xwiki.vfs.VfsResourceReference;

@Component
@Named(value="attach")
@Singleton
public class AttachVfsPermissionChecker
implements VfsPermissionChecker {
    @Inject
    private ContextualAuthorizationManager authorizationManager;
    @Inject
    private AttachmentReferenceResolver<String> defaultAttachmentReferenceresolver;

    @Override
    public void checkPermission(VfsResourceReference resourceReference) throws VfsException {
        AttachmentReference attachmentReference = this.defaultAttachmentReferenceresolver.resolve((Object)resourceReference.getURI().getSchemeSpecificPart(), new Object[0]);
        if (!this.authorizationManager.hasAccess(Right.VIEW, (EntityReference)attachmentReference)) {
            throw new VfsException(String.format("No View permission for attachment [%s]", attachmentReference));
        }
    }
}

