/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
/*!
#set ($paths = {
  'procolor': $xwiki.getSkinFile('uicomponents/widgets/colorpicker/procolor.js', true)
})
#[[*/
// Start JavaScript-only code.
(function(paths) {
  "use strict";

require.config({
  paths,
  shim: {
    procolor: {
      exports: 'ProColor'
    }
  }
});

require(['procolor'], function(ProColor) {
  var init = function(event) {
    ((event && event.memo.elements) || [$('body')]).each(function(element) {
      element.select('input.color-picker').each(function(input) {
        input.observe('focus', function(event) {
          new ProColor({
            mode: 'popup',
            input: input
          });
        });
      });
    });
    return true;
  };

  (XWiki.domIsLoaded && init()) || document.observe("xwiki:dom:loaded", init);
  document.observe('xwiki:dom:updated', init);
});

// End JavaScript-only code.
}).apply(']]#', $jsontool.serialize([$paths]));