/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.views.attachments;

import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavView;
import com.xpn.xwiki.plugin.webdav.resources.views.attachments.AttachmentsByFirstLettersSubView;
import com.xpn.xwiki.plugin.webdav.utils.XWikiDavUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentsBySpaceNameSubView
extends AbstractDavView {
    private static final Logger logger = LoggerFactory.getLogger(AttachmentsBySpaceNameSubView.class);

    @Override
    public XWikiDavResource decode(String[] tokens, int next) throws DavException {
        boolean last;
        String nextToken = tokens[next];
        boolean bl = last = next == tokens.length - 1;
        if (this.isTempResource(nextToken)) {
            return super.decode(tokens, next);
        }
        if (nextToken.startsWith("_") && nextToken.endsWith("_") && (!last || !this.getContext().isCreateOrMoveRequest())) {
            AttachmentsByFirstLettersSubView subView = new AttachmentsByFirstLettersSubView();
            subView.init(this, nextToken.toUpperCase(), "/" + nextToken.toUpperCase());
            return last ? subView : subView.decode(tokens, next + 1);
        }
        throw new DavException(400);
    }

    public DavResourceIterator getMembers() {
        ArrayList<XWikiDavResource> children = new ArrayList<XWikiDavResource>();
        try {
            String sql = ", XWikiAttachment as attach where doc.id = attach.docId and doc.web = '" + this.getDisplayName() + "'";
            List<String> docNames = this.getContext().searchDocumentsNames(sql);
            HashSet<String> subViewNames = new HashSet<String>();
            int subViewNameLength = XWikiDavUtils.getSubViewNameLength(docNames.size());
            for (String docName : docNames) {
                if (!this.getContext().hasAccess("view", docName)) continue;
                int dot = docName.lastIndexOf(46);
                String pageName = docName.substring(dot + 1);
                if (subViewNameLength < pageName.length()) {
                    subViewNames.add(pageName.substring(0, subViewNameLength).toUpperCase());
                    continue;
                }
                subViewNames.add(pageName.toUpperCase());
            }
            for (String subViewName : subViewNames) {
                try {
                    String modName = "_" + subViewName + "_";
                    AttachmentsByFirstLettersSubView subView = new AttachmentsByFirstLettersSubView();
                    subView.init(this, modName, "/" + modName);
                    children.add(subView);
                }
                catch (DavException e) {
                    logger.error("Unexpected Error : ", (Throwable)e);
                }
            }
        }
        catch (DavException ex) {
            logger.error("Unexpected Error : ", (Throwable)ex);
        }
        children.addAll(this.getVirtualMembers());
        return new DavResourceIteratorImpl(children);
    }
}

