/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.views.pages;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.domain.DavPage;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavResource;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavView;
import com.xpn.xwiki.plugin.webdav.resources.views.pages.PagesByFirstLettersSubView;
import com.xpn.xwiki.plugin.webdav.utils.XWikiDavUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagesBySpaceNameSubView
extends AbstractDavView {
    private static final Logger logger = LoggerFactory.getLogger(PagesBySpaceNameSubView.class);

    @Override
    public XWikiDavResource decode(String[] tokens, int next) throws DavException {
        String nextToken = tokens[next];
        boolean last = next == tokens.length - 1;
        AbstractDavResource resource = null;
        if (this.isTempResource(nextToken)) {
            return super.decode(tokens, next);
        }
        if (nextToken.startsWith("_") && nextToken.endsWith("_") && (!last || !this.getContext().isCreateOrMoveRequest())) {
            resource = new PagesByFirstLettersSubView();
            resource.init(this, nextToken.toUpperCase(), "/" + nextToken.toUpperCase());
        } else if (this.getContext().isCreateCollectionRequest() || this.getContext().exists(this.name + "." + nextToken)) {
            resource = new DavPage();
            resource.init(this, this.name + "." + nextToken, "/" + nextToken);
        } else if (nextToken.startsWith(this.name + ".") && this.getContext().exists(nextToken)) {
            resource = new DavPage();
            resource.init(this, nextToken, "/" + nextToken);
        } else {
            throw new DavException(400);
        }
        return last ? resource : resource.decode(tokens, next + 1);
    }

    @Override
    public boolean exists() {
        try {
            List<String> spaces = this.getContext().getSpaces();
            if (spaces.contains(this.name)) {
                return true;
            }
        }
        catch (DavException ex) {
            logger.error("Unexpected Error : ", (Throwable)ex);
        }
        return false;
    }

    public DavResourceIterator getMembers() {
        ArrayList<XWikiDavResource> children = new ArrayList<XWikiDavResource>();
        try {
            String sql = "where doc.web='" + this.name + "'";
            List<String> docNames = this.getContext().searchDocumentsNames(sql);
            HashSet<String> subViewNames = new HashSet<String>();
            int subViewNameLength = XWikiDavUtils.getSubViewNameLength(docNames.size());
            for (String docName : docNames) {
                if (!this.getContext().hasAccess("view", docName)) continue;
                int dot = docName.lastIndexOf(46);
                String pageName = docName.substring(dot + 1);
                if (subViewNameLength < pageName.length()) {
                    subViewNames.add(pageName.substring(0, subViewNameLength).toUpperCase());
                    continue;
                }
                subViewNames.add(pageName.toUpperCase());
            }
            for (String subViewName : subViewNames) {
                try {
                    String modName = "_" + subViewName + "_";
                    PagesByFirstLettersSubView subView = new PagesByFirstLettersSubView();
                    subView.init(this, modName, "/" + modName);
                    children.add(subView);
                }
                catch (DavException e) {
                    logger.error("Unexpected Error : ", (Throwable)e);
                }
            }
        }
        catch (DavException ex) {
            logger.error("Unexpected Error : ", (Throwable)ex);
        }
        children.addAll(this.getVirtualMembers());
        return new DavResourceIteratorImpl(children);
    }

    @Override
    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        if (resource instanceof DavPage) {
            String pName = resource.getDisplayName();
            if (this.getContext().hasAccess("edit", pName)) {
                XWikiDocument childDoc = this.getContext().getDocument(pName);
                childDoc.setContent("This page was created through the WebDAV interface.");
                this.getContext().saveDocument(childDoc);
            }
        } else {
            super.addMember(resource, inputContext);
        }
    }

    @Override
    public void removeMember(DavResource member) throws DavException {
        XWikiDavResource davResource = (XWikiDavResource)member;
        if (davResource instanceof DavPage) {
            String pName = davResource.getDisplayName();
            this.getContext().checkAccess("delete", pName);
            XWikiDocument childDoc = this.getContext().getDocument(pName);
            if (!childDoc.isNew()) {
                this.getContext().deleteDocument(childDoc);
            }
        } else if (member instanceof PagesByFirstLettersSubView) {
            String filter = member.getDisplayName().substring("_".length(), member.getDisplayName().length() - "_".length());
            String sql = "where doc.web='" + this.name + "'";
            List<String> docNames = this.getContext().searchDocumentsNames(sql);
            ArrayList<String> filteredDocNames = new ArrayList<String>();
            for (String docName : docNames) {
                if (!docName.toUpperCase().startsWith(filter)) continue;
                filteredDocNames.add(docName);
            }
            for (String docName : filteredDocNames) {
                this.getContext().checkAccess("delete", docName);
            }
            for (String docName : filteredDocNames) {
                this.getContext().deleteDocument(this.getContext().getDocument(docName));
            }
        } else {
            super.removeMember(member);
        }
        davResource.clearCache();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void move(DavResource destination) throws DavException {
        if (!(destination instanceof PagesBySpaceNameSubView)) throw new DavException(400);
        PagesBySpaceNameSubView dSpace = (PagesBySpaceNameSubView)destination;
        if (dSpace.exists()) throw new DavException(400);
        if (!this.getCollection().equals(dSpace.getCollection())) throw new DavException(400);
        String sql = "where doc.web='" + this.name + "'";
        List<String> docNames = this.getContext().searchDocumentsNames(sql);
        for (String docName : docNames) {
            String newDocName = dSpace.getDisplayName() + "." + docName;
            this.getContext().checkAccess("edit", docName);
            this.getContext().checkAccess("overwrite", newDocName);
        }
        for (String docName : docNames) {
            XWikiDocument doc = this.getContext().getDocument(docName);
            String newDocName = dSpace.getDisplayName() + "." + doc.getName();
            this.getContext().renameDocument(doc, newDocName);
        }
        this.clearCache();
    }
}

