/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.domain;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.domain.DavAttachment;
import com.xpn.xwiki.plugin.webdav.resources.domain.DavTempFile;
import com.xpn.xwiki.plugin.webdav.resources.domain.DavWikiFile;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DavPage
extends AbstractDavResource {
    private static final Logger logger = LoggerFactory.getLogger(DavPage.class);
    private String spaceName;
    private XWikiDocument doc;

    @Override
    public void init(XWikiDavResource parent, String name, String relativePath) throws DavException {
        super.init(parent, name, relativePath);
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            throw new DavException(400);
        }
        this.spaceName = name.substring(0, dot);
        this.doc = this.getContext().getDocument(this.name);
        String timeStamp = DavConstants.creationDateFormat.format(this.doc.getCreationDate());
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.CREATIONDATE, (Object)timeStamp));
        timeStamp = DavConstants.modificationDateFormat.format(this.doc.getContentUpdateDate());
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETLASTMODIFIED, (Object)timeStamp));
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETETAG, (Object)timeStamp));
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTTYPE, (Object)"text/directory"));
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLANGUAGE, (Object)this.doc.getLanguage()));
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)0));
    }

    @Override
    public XWikiDavResource decode(String[] tokens, int next) throws DavException {
        String nextToken = tokens[next];
        boolean last = next == tokens.length - 1;
        AbstractDavResource resource = null;
        String relativePath = "/" + nextToken;
        if (this.isTempResource(nextToken)) {
            return super.decode(tokens, next);
        }
        if (nextToken.equals("wiki.txt") || nextToken.equals("wiki.xml")) {
            resource = new DavWikiFile();
            resource.init(this, nextToken, relativePath);
        } else if (this.doc.getAttachment(nextToken) != null || last && this.getContext().isCreateFileRequest() || last && this.getContext().isMoveAttachmentRequest(this.doc)) {
            resource = new DavAttachment();
            resource.init(this, nextToken, relativePath);
        } else {
            int dot = nextToken.indexOf(46);
            String pageName = dot != -1 ? nextToken : this.spaceName + "." + nextToken;
            resource = new DavPage();
            resource.init(this, pageName, relativePath);
        }
        return last ? resource : resource.decode(tokens, next + 1);
    }

    public boolean exists() {
        return !this.doc.isNew();
    }

    public DavResourceIterator getMembers() {
        ArrayList<XWikiDavResource> children = new ArrayList<XWikiDavResource>();
        if (!this.getContext().hasAccess("view", this.name)) {
            return new DavResourceIteratorImpl(children);
        }
        try {
            String sql = "where doc.parent='" + this.name + "'";
            List<String> docNames = this.getContext().searchDocumentsNames(sql);
            for (String docName : docNames) {
                if (this.createsCycle(docName) || !this.getContext().hasAccess("view", docName)) continue;
                XWikiDocument childDoc = this.getContext().getDocument(docName);
                DavPage page = new DavPage();
                if (childDoc.getSpace().equals(this.spaceName)) {
                    page.init(this, docName, "/" + childDoc.getName());
                } else {
                    page.init(this, docName, "/" + docName);
                }
                children.add(page);
            }
            sql = "select attach.filename from XWikiAttachment as attach, XWikiDocument as doc where attach.docId=doc.id and doc.fullName='" + this.name + "'";
            List<Object> attachments = this.getContext().search(sql);
            for (int i = 0; i < attachments.size(); ++i) {
                String filename = (String)attachments.get(i);
                DavAttachment attachment = new DavAttachment();
                attachment.init(this, filename, "/" + filename);
                children.add(attachment);
            }
            children.addAll(this.getVirtualMembers());
        }
        catch (DavException e) {
            logger.error("Unexpected Error : ", (Throwable)e);
        }
        return new DavResourceIteratorImpl(children);
    }

    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        boolean isFile;
        this.getContext().checkAccess("edit", this.name);
        boolean bl = isFile = inputContext.getInputStream() != null;
        if (resource instanceof DavTempFile) {
            this.addVirtualMember(resource, inputContext);
        } else if (resource instanceof DavPage) {
            String pName = resource.getDisplayName();
            this.getContext().checkAccess("edit", pName);
            XWikiDocument childDoc = this.getContext().getDocument(pName);
            childDoc.setContent("This page was created through the WebDAV interface.");
            childDoc.setParent(this.name);
            this.getContext().saveDocument(childDoc);
        } else if (isFile) {
            String fName = resource.getDisplayName();
            byte[] data = this.getContext().getFileContentAsBytes(inputContext.getInputStream());
            if (fName.equals("wiki.txt")) {
                this.doc.setContent(new String(data));
                this.getContext().saveDocument(this.doc);
            } else {
                if (fName.equals("wiki.xml")) {
                    throw new DavException(405);
                }
                this.getContext().addAttachment(this.doc, data, fName);
            }
        } else {
            throw new DavException(500);
        }
    }

    public void removeMember(DavResource member) throws DavException {
        this.getContext().checkAccess("edit", this.name);
        XWikiDavResource dResource = (XWikiDavResource)member;
        String mName = dResource.getDisplayName();
        if (dResource instanceof DavTempFile) {
            this.removeVirtualMember(dResource);
        } else if (dResource instanceof DavWikiFile) {
            this.getContext().checkAccess("delete", this.name);
            this.removeVirtualMember(dResource);
        } else if (dResource instanceof DavAttachment) {
            this.getContext().deleteAttachment(this.doc.getAttachment(mName));
        } else if (dResource instanceof DavPage) {
            XWikiDocument childDoc = this.getContext().getDocument(mName);
            this.getContext().checkAccess("delete", childDoc.getFullName());
            if (!childDoc.isNew()) {
                this.getContext().deleteDocument(childDoc);
            }
        } else {
            throw new DavException(500);
        }
        dResource.clearCache();
    }

    public void move(DavResource destination) throws DavException {
        this.getContext().checkAccess("edit", this.name);
        if (destination instanceof DavPage) {
            DavPage dPage = (DavPage)destination;
            XWikiDocument dDoc = dPage.getDocument();
            List<String> spaces = this.getContext().getSpaces();
            if (spaces.contains(dDoc.getSpace())) {
                String newDocName = dDoc.getFullName();
                String sql = "where doc.parent='" + this.name + "'";
                List<String> childDocNames = this.getContext().searchDocumentsNames(sql);
                this.getContext().checkAccess("overwrite", newDocName);
                for (String childDocName : childDocNames) {
                    this.getContext().checkAccess("edit", childDocName);
                }
                this.getContext().renameDocument(this.doc, newDocName);
                for (String childDocName : childDocNames) {
                    XWikiDocument childDoc = this.getContext().getDocument(childDocName);
                    childDoc.setParent(newDocName);
                    this.getContext().saveDocument(childDoc);
                }
            }
        } else {
            throw new DavException(400);
        }
        this.clearCache();
    }

    @Override
    public List<XWikiDavResource> getInitMembers() {
        ArrayList<XWikiDavResource> initialMembers = new ArrayList<XWikiDavResource>();
        try {
            DavWikiFile wikiText = new DavWikiFile();
            wikiText.init(this, "wiki.txt", "/wiki.txt");
            initialMembers.add(wikiText);
            DavWikiFile wikiXml = new DavWikiFile();
            wikiXml.init(this, "wiki.xml", "/wiki.xml");
            initialMembers.add(wikiXml);
        }
        catch (DavException ex) {
            logger.error("Error while initializing members.", (Throwable)ex);
        }
        return initialMembers;
    }

    public boolean isCollection() {
        return true;
    }

    public void spool(OutputContext outputContext) throws IOException {
        throw new IOException("Collection resources can't be spooled");
    }

    public long getModificationTime() {
        if (this.exists()) {
            return this.doc.getContentUpdateDate().getTime();
        }
        return -1L;
    }

    public XWikiDocument getDocument() {
        return this.doc;
    }

    public boolean createsCycle(String childDocName) {
        for (DavPage ancestor = this; ancestor instanceof DavPage && ancestor != null; ancestor = ancestor.getCollection()) {
            if (!ancestor.getDisplayName().equals(childDocName)) continue;
            return true;
        }
        return false;
    }
}

