/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.utils;

import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Document;

public final class XWikiDavUtils {
    public static final String URL_SEPARATOR = "/";
    public static final String VIRTUAL_DIRECTORY_PREFIX = "_";
    public static final String VIRTUAL_DIRECTORY_POSTFIX = "_";
    public static final String XWIKI_ATTACHMENT_SIGNATURE = "/xwiki/bin/download/";
    public static final String XWIKI_WEBDAV_SIGNATURE = "/xwiki/webdav/spaces/";

    private XWikiDavUtils() {
    }

    public static int getSubViewNameLength(int totalDocumentCount) {
        if (totalDocumentCount < 200) {
            return 1;
        }
        if (totalDocumentCount < 5000) {
            return 2;
        }
        return 3;
    }

    public static String getDavURL(Document doc, Attachment attachment) {
        String docDownloadURL = doc.getExternalURL("download");
        String httpUrl = docDownloadURL.endsWith(URL_SEPARATOR) ? docDownloadURL + attachment.getFilename() : docDownloadURL + URL_SEPARATOR + attachment.getFilename();
        return XWikiDavUtils.getDavURL(httpUrl);
    }

    private static String getDavURL(String httpUrl) {
        String webDAVUrl = "";
        if (httpUrl.contains(XWIKI_ATTACHMENT_SIGNATURE)) {
            String[] parts = httpUrl.split(XWIKI_ATTACHMENT_SIGNATURE);
            String[] elements = parts[1].split(URL_SEPARATOR);
            webDAVUrl = parts[0] + XWIKI_WEBDAV_SIGNATURE + elements[0] + URL_SEPARATOR + elements[1] + URL_SEPARATOR + elements[2];
        }
        return webDAVUrl;
    }

    public static interface BaseViews {
        public static final String ROOT = "root";
        public static final String PAGES = "spaces";
        public static final String ATTACHMENTS = "attachments";
        public static final String HOME = "home";
        public static final String ORPHANS = "orphans";
        public static final String WHATSNEW = "whatsnew";
    }
}

