/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.utils;

import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.views.RootView;
import com.xpn.xwiki.plugin.webdav.utils.XWikiDavContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.SimpleLockManager;

public class XWikiDavResourceFactory
implements DavResourceFactory {
    private ServletContext servletContext;
    private final LockManager lockManager = new SimpleLockManager();

    public XWikiDavResourceFactory(ServletContext servletContext) throws ServletException {
        this.servletContext = servletContext;
    }

    public DavResource createResource(DavResourceLocator locator, DavServletRequest request, DavServletResponse response) throws DavException {
        return this.createResource(locator, request.getDavSession(), request, response);
    }

    public DavResource createResource(DavResourceLocator locator, DavSession session) throws DavException {
        return this.createResource(locator, session, null, null);
    }

    public XWikiDavResource createResource(DavResourceLocator locator, DavSession session, DavServletRequest request, DavServletResponse response) throws DavException {
        String baseURI = "/webdav";
        DavResourceLocator rootLocator = locator.getFactory().createResourceLocator(locator.getPrefix(), baseURI, baseURI);
        XWikiDavContext context = new XWikiDavContext(request, response, this.servletContext, this, session, this.lockManager);
        RootView root = new RootView();
        root.init("webdav", rootLocator, context);
        String workspacePath = locator.getWorkspacePath();
        String[] tokens = locator.getResourcePath().split("/");
        if (workspacePath != null && workspacePath.equals(baseURI) && tokens.length >= 2) {
            return tokens.length == 2 ? root : root.decode(tokens, 2);
        }
        throw new DavException(400);
    }
}

