/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.views.pages;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavView;
import com.xpn.xwiki.plugin.webdav.resources.views.pages.PagesBySpaceNameSubView;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagesView
extends AbstractDavView {
    private static final Logger logger = LoggerFactory.getLogger(PagesView.class);

    @Override
    public XWikiDavResource decode(String[] tokens, int next) throws DavException {
        boolean last;
        String nextToken = tokens[next];
        boolean bl = last = next == tokens.length - 1;
        if (this.isTempResource(nextToken)) {
            return super.decode(tokens, next);
        }
        if (!last || !this.getContext().isCreateFileRequest()) {
            PagesBySpaceNameSubView subView = new PagesBySpaceNameSubView();
            subView.init(this, nextToken, "/" + nextToken);
            return last ? subView : subView.decode(tokens, next + 1);
        }
        throw new DavException(400);
    }

    public DavResourceIterator getMembers() {
        ArrayList<XWikiDavResource> children = new ArrayList<XWikiDavResource>();
        try {
            List<String> spaceNames = this.getContext().getSpaces();
            for (String spaceName : spaceNames) {
                PagesBySpaceNameSubView subView = new PagesBySpaceNameSubView();
                subView.init(this, spaceName, "/" + spaceName);
                children.add(subView);
            }
        }
        catch (DavException e) {
            logger.error("Unexpected Error : ", (Throwable)e);
        }
        children.addAll(this.getVirtualMembers());
        return new DavResourceIteratorImpl(children);
    }

    @Override
    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        if (resource instanceof PagesBySpaceNameSubView) {
            String homePage = resource.getDisplayName() + ".WebHome";
            this.getContext().checkAccess("edit", homePage);
            XWikiDocument doc = this.getContext().getDocument(resource.getDisplayName() + ".WebHome");
            doc.setContent("This page was created through the WebDAV interface.");
            this.getContext().saveDocument(doc);
        } else {
            super.addMember(resource, inputContext);
        }
    }

    @Override
    public void removeMember(DavResource member) throws DavException {
        XWikiDavResource davResource = (XWikiDavResource)member;
        if (davResource instanceof PagesBySpaceNameSubView) {
            PagesBySpaceNameSubView space = (PagesBySpaceNameSubView)davResource;
            String sql = "where doc.web='" + space.getDisplayName() + "'";
            List<String> docNames = this.getContext().searchDocumentsNames(sql);
            for (String docName : docNames) {
                this.getContext().checkAccess("delete", docName);
            }
            for (String docName : docNames) {
                XWikiDocument doc = this.getContext().getDocument(docName);
                this.getContext().deleteDocument(doc);
            }
        } else {
            super.removeMember(member);
        }
        davResource.clearCache();
    }
}

