/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.resource.AbstractResourceReference;
import org.xwiki.resource.ResourceType;

public class WebJarsResourceReference
extends AbstractResourceReference {
    public static final ResourceType TYPE = new ResourceType("webjars");
    private static final char RESOURCE_PATH_SEPARATOR = '/';
    private String namespace;
    private List<String> resourceSegments;

    public WebJarsResourceReference(String namespace, List<String> resourceSegments) {
        this.setType(TYPE);
        this.namespace = namespace;
        this.resourceSegments = new ArrayList<String>(resourceSegments);
    }

    public List<String> getResourceSegments() {
        return this.resourceSegments;
    }

    public String getResourceName() {
        return StringUtils.join(this.getResourceSegments(), (char)'/');
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int hashCode() {
        return new HashCodeBuilder(5, 5).append(this.getResourceSegments()).append((Object)this.getType()).append((Object)this.getNamespace()).append((Object)this.getParameters()).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        WebJarsResourceReference rhs = (WebJarsResourceReference)((Object)object);
        return new EqualsBuilder().append(this.getResourceSegments(), rhs.getResourceSegments()).append((Object)this.getType(), (Object)rhs.getType()).append((Object)this.getNamespace(), (Object)rhs.getNamespace()).append((Object)this.getParameters(), (Object)rhs.getParameters()).isEquals();
    }
}

