/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.internal;

import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.resource.CreateResourceReferenceException;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.internal.AbstractResourceReferenceResolver;
import org.xwiki.webjars.internal.WebJarsResourceReference;

@Component
@Named(value="webjars")
@Singleton
public class WebJarsResourceReferenceResolver
extends AbstractResourceReferenceResolver {
    public WebJarsResourceReference resolve(ExtendedURL extendedURL, ResourceType resourceType, Map<String, Object> parameters) throws CreateResourceReferenceException, UnsupportedResourceReferenceException {
        List segments = extendedURL.getSegments();
        if (segments.size() <= 1) {
            throw new CreateResourceReferenceException(String.format("Invalid WebJars URL format [%s]", extendedURL.toString()));
        }
        String namespace = (String)segments.get(0);
        List<String> resourceSegments = segments.subList(1, segments.size());
        WebJarsResourceReference reference = new WebJarsResourceReference(namespace, resourceSegments);
        this.copyParameters(extendedURL, (ResourceReference)reference);
        return reference;
    }
}

