/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.tika.Tika;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.Response;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.container.servlet.ServletResponse;
import org.xwiki.resource.AbstractResourceReferenceHandler;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandlerChain;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.entity.EntityResourceAction;

@Component
@Named(value="webjars")
@Singleton
public class WebJarsResourceReferenceHandler
extends AbstractResourceReferenceHandler<EntityResourceAction> {
    public static final EntityResourceAction ACTION = new EntityResourceAction("webjars");
    private static final String WEBJARS_RESOURCE_PREFIX = "META-INF/resources/webjars/";
    @Inject
    private Container container;
    private Tika tika = new Tika();

    public List<EntityResourceAction> getSupportedResourceReferences() {
        return Arrays.asList(ACTION);
    }

    public void handle(ResourceReference reference, ResourceReferenceHandlerChain chain) throws ResourceReferenceHandlerException {
        if (!this.shouldBrowserUseCachedContent()) {
            String resourceName = reference.getParameterValue("value");
            String resourcePath = String.format("%s%s", WEBJARS_RESOURCE_PREFIX, resourceName);
            InputStream resourceStream = this.getClassLoader().getResourceAsStream(resourcePath);
            if (resourceStream != null) {
                if (!resourceStream.markSupported()) {
                    resourceStream = new BufferedInputStream(resourceStream);
                }
                try {
                    Response response = this.container.getResponse();
                    this.setResponseHeaders(response);
                    response.setContentType(this.tika.detect(resourceStream, resourceName));
                    IOUtils.copy((InputStream)resourceStream, (OutputStream)this.container.getResponse().getOutputStream());
                }
                catch (IOException e) {
                    throw new ResourceReferenceHandlerException(String.format("Failed to read resource [%s]", resourceName), (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)resourceStream);
                }
            }
        }
        chain.handleNext(reference);
    }

    private void setResponseHeaders(Response response) {
        if (response instanceof ServletResponse) {
            HttpServletResponse httpResponse = ((ServletResponse)response).getHttpServletResponse();
            httpResponse.setDateHeader("Last-Modified", new Date().getTime() / 1000L * 1000L);
        }
    }

    private boolean shouldBrowserUseCachedContent() {
        Response response;
        HttpServletRequest httpRequest;
        Request request = this.container.getRequest();
        if (request instanceof ServletRequest && (httpRequest = ((ServletRequest)request).getHttpServletRequest()).getHeader("If-Modified-Since") != null && (response = this.container.getResponse()) instanceof ServletResponse) {
            HttpServletResponse httpResponse = ((ServletResponse)response).getHttpServletResponse();
            httpResponse.setStatus(304);
            return true;
        }
        return false;
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

