/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.descriptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.wiki.properties.WikiPropertyGroup;

public class WikiDescriptor {
    private static final int DEFAULT_ALIAS_INDEX = 0;
    private String id;
    private List<String> aliases = new ArrayList<String>();
    private String prettyName;
    private LocalDocumentReference mainPageReference = new LocalDocumentReference("Main", "WebHome");
    private String ownerId;
    private boolean isHidden;
    private String description;
    private Map<String, WikiPropertyGroup> propertyGroups;

    public WikiDescriptor(String id, String defaultAlias) {
        this.id = id;
        this.aliases = new ArrayList<String>();
        this.propertyGroups = new HashMap<String, WikiPropertyGroup>();
        this.setDefaultAlias(defaultAlias);
    }

    public String getId() {
        return this.id;
    }

    public String getDefaultAlias() {
        return this.aliases.get(0);
    }

    public void setDefaultAlias(String alias) {
        if (this.aliases.isEmpty()) {
            this.aliases.add(alias);
        } else {
            this.aliases.set(0, alias);
        }
    }

    public void addAlias(String alias) {
        this.aliases.add(alias);
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public void setPrettyName(String prettyName) {
        this.prettyName = prettyName;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public WikiReference getReference() {
        return new WikiReference(this.getId());
    }

    public DocumentReference getMainPageReference() {
        return new DocumentReference(this.getId(), this.mainPageReference.getParent().getName(), this.mainPageReference.getName());
    }

    public void setMainPageReference(DocumentReference reference) {
        this.mainPageReference = new LocalDocumentReference(reference.getParent().getName(), reference.getName());
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WikiPropertyGroup getPropertyGroup(String propertyGroupId) {
        return this.propertyGroups.get(propertyGroupId);
    }

    public void addPropertyGroup(WikiPropertyGroup group) {
        this.propertyGroups.put(group.getId(), group);
    }

    public int hashCode() {
        return new HashCodeBuilder(3, 3).append((Object)this.getDefaultAlias()).append((Object)this.getId()).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        WikiDescriptor rhs = (WikiDescriptor)object;
        return new EqualsBuilder().append((Object)this.getDefaultAlias(), (Object)rhs.getDefaultAlias()).append((Object)this.getId(), (Object)rhs.getId()).isEquals();
    }
}

