/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.wiki.creationjob.internal.steps;

import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.platform.wiki.creationjob.WikiCreationException;
import org.xwiki.platform.wiki.creationjob.WikiCreationRequest;
import org.xwiki.platform.wiki.creationjob.WikiCreationStep;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;
import org.xwiki.wiki.template.WikiTemplateManager;
import org.xwiki.wiki.template.WikiTemplateManagerException;
import org.xwiki.wiki.user.WikiUserManager;
import org.xwiki.wiki.user.WikiUserManagerException;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="metadata")
public class SaveWikiMetaDataStep
implements WikiCreationStep {
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private WikiTemplateManager wikiTemplateManager;
    @Inject
    private WikiUserManager wikiUserManager;

    @Override
    public void execute(WikiCreationRequest request) throws WikiCreationException {
        try {
            String wikiId = request.getWikiId();
            WikiDescriptor descriptor = this.wikiDescriptorManager.getById(wikiId);
            descriptor.setDescription(request.getDescription());
            descriptor.setPrettyName(request.getPrettyName());
            this.wikiDescriptorManager.saveDescriptor(descriptor);
            this.wikiTemplateManager.setTemplate(wikiId, request.isTemplate());
            this.wikiUserManager.setUserScope(wikiId, request.getUserScope());
            this.wikiUserManager.setMembershipType(wikiId, request.getMembershipType());
        }
        catch (WikiManagerException | WikiTemplateManagerException | WikiUserManagerException e) {
            throw new WikiCreationException(String.format("Failed to set metadata to the wiki [%s].", request.getWikiId()), e);
        }
    }

    @Override
    public int getOrder() {
        return 2000;
    }
}

