/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.wiki.creationjob.internal;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.JobStatusStore;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.platform.wiki.creationjob.WikiCreationException;
import org.xwiki.platform.wiki.creationjob.WikiCreationRequest;
import org.xwiki.platform.wiki.creationjob.WikiCreator;

@Component
@Singleton
public class DefaultWikiCreator
implements WikiCreator {
    @Inject
    private JobExecutor jobExecutor;
    @Inject
    private JobStatusStore jobStatusStore;

    @Override
    public Job createWiki(WikiCreationRequest request) throws WikiCreationException {
        try {
            request.setId(this.getJobId(request.getWikiId()));
            return this.jobExecutor.execute("wikicreationjob", (Request)request);
        }
        catch (JobException e) {
            throw new WikiCreationException("Failed to create a new wiki.", e);
        }
    }

    @Override
    public JobStatus getJobStatus(String wikiId) {
        List<String> jobId = this.getJobId(wikiId);
        Job job = this.jobExecutor.getJob(jobId);
        if (job != null) {
            return job.getStatus();
        }
        return this.jobStatusStore.getJobStatus(jobId);
    }

    private List<String> getJobId(String wikiId) {
        return Arrays.asList("wikicreation", "createandinstall", wikiId);
    }
}

