/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.wiki.creationjob.internal.steps;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.bridge.event.WikiCopiedEvent;
import org.xwiki.bridge.event.WikiProvisionedEvent;
import org.xwiki.bridge.event.WikiProvisioningEvent;
import org.xwiki.bridge.event.WikiProvisioningFailedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.platform.wiki.creationjob.WikiCreationException;
import org.xwiki.platform.wiki.creationjob.WikiCreationRequest;
import org.xwiki.platform.wiki.creationjob.WikiCreationStep;
import org.xwiki.platform.wiki.creationjob.internal.ExtensionInstaller;
import org.xwiki.wiki.manager.WikiManagerException;
import org.xwiki.wiki.provisioning.WikiCopier;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="provision")
public class ProvisionWikiStep
implements WikiCreationStep {
    @Inject
    private WikiCopier wikiCopier;
    @Inject
    private ExtensionInstaller extensionInstaller;
    @Inject
    private ObservationManager observationManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    @Override
    public void execute(WikiCreationRequest request) throws WikiCreationException {
        try {
            if (request.getWikiSource() == null) {
                return;
            }
            switch (request.getWikiSource()) {
                case EXTENSION: {
                    this.sendWikiProvisioningEvent(request);
                    this.extensionInstaller.installExtension(request.getWikiId(), request.getExtensionId());
                    this.sendWikiProvisionedEvent(request);
                    break;
                }
                case TEMPLATE: {
                    this.sendWikiProvisioningEvent(request);
                    this.wikiCopier.copyDocuments(request.getTemplateId(), request.getWikiId(), false);
                    this.observationManager.notify((Event)new WikiCopiedEvent(request.getTemplateId(), request.getWikiId()), (Object)request.getTemplateId(), this.xcontextProvider.get());
                    this.sendWikiProvisionedEvent(request);
                    break;
                }
            }
        }
        catch (WikiCreationException | WikiManagerException e) {
            this.observationManager.notify((Event)new WikiProvisioningFailedEvent(request.getWikiId()), (Object)request.getWikiId(), this.xcontextProvider.get());
            throw new WikiCreationException(String.format("Failed to provision the wiki [%s].", request.getWikiId()), e);
        }
    }

    private void sendWikiProvisioningEvent(WikiCreationRequest request) {
        this.observationManager.notify((Event)new WikiProvisioningEvent(request.getWikiId()), (Object)request.getWikiId(), this.xcontextProvider.get());
    }

    private void sendWikiProvisionedEvent(WikiCreationRequest request) {
        this.observationManager.notify((Event)new WikiProvisionedEvent(request.getWikiId()), (Object)request.getWikiId(), this.xcontextProvider.get());
    }

    @Override
    public int getOrder() {
        return 3000;
    }
}

