/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.manager;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.internal.descriptor.document.WikiDescriptorDocumentHelper;
import org.xwiki.wiki.internal.manager.WikiDeleter;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Singleton
public class DefaultWikiDeleter
implements WikiDeleter {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private WikiDescriptorDocumentHelper descriptorDocumentHelper;

    @Override
    public void delete(String wikiId) throws WikiManagerException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = context.getWiki();
        if (wikiId.equals(this.wikiDescriptorManager.getMainWikiId())) {
            throw new WikiManagerException("It's not allowed to delete the main wiki!");
        }
        try {
            XWikiDocument descriptorDocument = this.descriptorDocumentHelper.getDocumentFromWikiId(wikiId);
            xwiki.deleteDocument(descriptorDocument, context);
        }
        catch (XWikiException e) {
            throw new WikiManagerException(String.format("Error deleting the Wiki Descriptor Document for database [%s]", wikiId), (Throwable)e);
        }
        try {
            xwiki.getStore().deleteWiki(wikiId, context);
        }
        catch (XWikiException e) {
            throw new WikiManagerException(String.format("Error deleting the database [%s]", wikiId), (Throwable)e);
        }
    }
}

