/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.descriptor.document;

import com.xpn.xwiki.doc.AbstractMandatoryClassInitializer;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.BaseClass;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.sheet.SheetBinder;

@Component
@Named(value="XWiki.XWikiServerClass")
@Singleton
public class XWikiServerClassDocumentInitializer
extends AbstractMandatoryClassInitializer {
    public static final String DOCUMENT_NAME = "XWikiServerClass";
    public static final LocalDocumentReference SERVER_CLASS = new LocalDocumentReference("XWiki", "XWikiServerClass");
    public static final String DEFAULT_FIELDS_SEPARATOR = "|";
    public static final String FIELD_WIKIPRETTYNAME = "wikiprettyname";
    public static final String FIELDPN_WIKIPRETTYNAME = "Wiki pretty name";
    public static final String FIELD_OWNER = "owner";
    public static final String FIELDPN_OWNER = "Owner";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELDPN_DESCRIPTION = "Description";
    public static final String FIELD_SERVER = "server";
    public static final String FIELDPN_SERVER = "Server";
    public static final String FIELD_VISIBILITY = "visibility";
    public static final String FIELDL_VISIBILITY_PUBLIC = "public";
    public static final String FIELDL_VISIBILITY_PRIVATE = "private";
    public static final String FIELDL_VISIBILITY = "public|private|";
    public static final String FIELDPN_VISIBILITY = "Visibility";
    public static final String FIELD_STATE = "state";
    public static final String FIELDL_STATE_ACTIVE = "active";
    public static final String FIELDL_STATE_INACTIVE = "inactive";
    public static final String FIELDL_STATE_LOCKED = "locked";
    public static final String FIELDL_STATE = "active|inactive|locked";
    public static final String FIELDPN_STATE = "State";
    public static final String FIELD_LANGUAGE = "language";
    public static final String FIELDL_LANGUAGE = "en|fr";
    public static final String FIELDPN_LANGUAGE = "Language";
    public static final String FIELD_SECURE = "secure";
    public static final String FIELDPN_SECURE = "Secure";
    public static final String FIELDFT_SECURE = "select";
    public static final String FIELDDT_SECURE = "";
    public static final Boolean DEFAULT_SECURE = null;
    public static final String FIELD_PORT = "port";
    public static final String FIELDPN_PORT = "Port";
    public static final String FIELDT_PORT = "integer";
    public static final String FIELD_HOMEPAGE = "homepage";
    public static final String FIELDPN_HOMEPAGE = "Home page";
    @Inject
    @Named(value="class")
    private SheetBinder classSheetBinder;

    public XWikiServerClassDocumentInitializer() {
        super((EntityReference)SERVER_CLASS);
    }

    public boolean isMainWikiOnly() {
        return true;
    }

    protected void createClass(BaseClass xclass) {
        xclass.addTextField(FIELD_WIKIPRETTYNAME, FIELDPN_WIKIPRETTYNAME, 30);
        xclass.addUsersField(FIELD_OWNER, FIELDPN_OWNER, false);
        xclass.addTextAreaField(FIELD_DESCRIPTION, FIELDPN_DESCRIPTION, 40, 5);
        xclass.addTextField(FIELD_SERVER, FIELDPN_SERVER, 30);
        xclass.addStaticListField(FIELD_VISIBILITY, FIELDPN_VISIBILITY, FIELDL_VISIBILITY);
        xclass.addStaticListField(FIELD_STATE, FIELDPN_STATE, FIELDL_STATE);
        xclass.addStaticListField(FIELD_LANGUAGE, FIELDPN_LANGUAGE, FIELDL_LANGUAGE);
        xclass.addBooleanField(FIELD_SECURE, FIELDPN_SECURE, FIELDFT_SECURE, FIELDDT_SECURE, DEFAULT_SECURE);
        xclass.addNumberField(FIELD_PORT, FIELDPN_PORT, 4, FIELDT_PORT);
        xclass.addPageField(FIELD_HOMEPAGE, FIELDPN_HOMEPAGE, 30);
    }

    public boolean updateDocument(XWikiDocument document) {
        boolean needsUpdate = super.updateDocument(document);
        if (this.classSheetBinder.getSheets((DocumentModelBridge)document).isEmpty()) {
            String wikiName = document.getDocumentReference().getWikiReference().getName();
            DocumentReference sheet = new DocumentReference(wikiName, "XWiki", "XWikiServerClassSheet");
            needsUpdate |= this.classSheetBinder.bind((DocumentModelBridge)document, sheet);
        }
        return needsUpdate;
    }
}

