/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.wikimanager;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerPluginApi;
import com.xpn.xwiki.plugin.applicationmanager.core.plugin.XWikiPluginMessageTool;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplication;
import com.xpn.xwiki.plugin.packaging.PackageAPI;
import com.xpn.xwiki.plugin.wikimanager.WikiManager;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerException;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerMessageTool;
import com.xpn.xwiki.plugin.wikimanager.doc.XWikiServer;
import com.xpn.xwiki.plugin.wikimanager.doc.XWikiServerClass;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.rendering.syntax.Syntax;

public final class WikiCopy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(WikiManager.class);
    private XWikiPluginMessageTool messageTool;

    public WikiCopy(XWikiPluginMessageTool messageTool) {
        this.messageTool = messageTool;
    }

    public XWikiPluginMessageTool getMessageTool(XWikiContext context) {
        return this.messageTool != null ? this.messageTool : WikiManagerMessageTool.getDefault(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String>[] getDocsNames(String wiki, XWikiContext context) throws XWikiException {
        Collection[] docsNames = new Collection[2];
        ApplicationManagerPluginApi appmanager = (ApplicationManagerPluginApi)context.getWiki().getPluginApi("applicationmanager", context);
        if (appmanager == null) {
            return null;
        }
        String database = context.getDatabase();
        try {
            context.setDatabase(wiki);
            XWikiApplication rootApp = appmanager.getRootApplication();
            if (rootApp != null) {
                docsNames[0] = rootApp.getDocsNameToInclude(true);
                docsNames[1] = rootApp.getDocsNameToLink(true);
            } else {
                List applications = appmanager.getApplicationDocumentList();
                docsNames[0] = XWikiApplication.getDocsNameToInclude((Collection)applications);
                docsNames[1] = XWikiApplication.getDocsNameToLink((Collection)applications);
            }
        }
        finally {
            context.setDatabase(database);
        }
        return docsNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyWiki(String sourceWiki, String targetWiki, String comment, XWikiContext context) throws XWikiException {
        XWiki xwiki = context.getWiki();
        xwiki.copyWiki(sourceWiki, targetWiki, null, context);
        String database = context.getDatabase();
        try {
            context.setDatabase(targetWiki);
            Collection<String>[] docsNames = this.getDocsNames(sourceWiki, context);
            if (docsNames != null) {
                XWikiDocument targetDoc;
                String docFullName;
                String item;
                Object[] includeFormatParams = new Object[]{sourceWiki, ":", null};
                Iterator<String> i$ = docsNames[0].iterator();
                while (i$.hasNext()) {
                    docFullName = item = i$.next();
                    targetDoc = xwiki.getDocument(docFullName, context);
                    includeFormatParams[2] = docFullName;
                    targetDoc.setContent(MessageFormat.format("#includeInContext(\"{0}{1}{2}\")", includeFormatParams));
                    targetDoc.setSyntax(Syntax.XWIKI_1_0);
                    xwiki.saveDocument(targetDoc, context);
                }
                i$ = docsNames[1].iterator();
                while (i$.hasNext()) {
                    docFullName = item = i$.next();
                    targetDoc = xwiki.getDocument(docFullName, context);
                    includeFormatParams[2] = docFullName;
                    targetDoc.setContent(MessageFormat.format("#includeTopic(\"{0}{1}{2}\")", includeFormatParams));
                    targetDoc.setSyntax(Syntax.XWIKI_1_0);
                    xwiki.saveDocument(targetDoc, context);
                }
            }
        }
        finally {
            context.setDatabase(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importPackage(String packageName, String targetWiki, XWikiContext context) throws XWikiException {
        XWikiPluginMessageTool msg = this.getMessageTool(context);
        XWiki xwiki = context.getWiki();
        if (!xwiki.isVirtualMode()) {
            throw new WikiManagerException(50037, msg.get("wikimanager.plugin.error.xwikinotvirtual"));
        }
        XWikiDocument doc = context.getDoc();
        XWikiAttachment packFile = doc.getAttachment(packageName);
        if (packFile == null) {
            throw new WikiManagerException(50038, msg.get("wikimanager.plugin.error.packagedoesnotexists", packageName));
        }
        PackageAPI importer = (PackageAPI)context.getWiki().getPluginApi("package", context);
        String database = context.getDatabase();
        try {
            context.setDatabase(targetWiki);
            try {
                importer.Import(packFile.getContent(context));
            }
            catch (IOException e) {
                throw new WikiManagerException(50039, msg.get("wikimanager.plugin.error.packageimport", packageName), e);
            }
            if (importer.install() == 0) {
                throw new WikiManagerException(50040, msg.get("wikimanager.plugin.error.packageinstall", packageName));
            }
        }
        finally {
            context.setDatabase(database);
        }
    }

    public XWikiServer getWikiTemplateAlias(String wikiName, int objectId, XWikiContext context, boolean validate) throws XWikiException {
        return XWikiServerClass.getInstance(context).getWikiTemplateAlias(wikiName, objectId, validate, context);
    }

    public List<XWikiServer> getWikiTemplateAliasList(XWikiContext context) throws XWikiException {
        return XWikiServerClass.getInstance(context).searchXObjectDocumentsByField("iswikitemplate", 1, "IntegerProperty", context);
    }
}

