/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.wikimanager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.PluginApi;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.applicationmanager.core.api.XWikiExceptionApi;
import com.xpn.xwiki.plugin.globalsearch.GlobalSearchPluginApi;
import com.xpn.xwiki.plugin.wikimanager.WikiManager;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerException;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerMessageTool;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerPlugin;
import com.xpn.xwiki.plugin.wikimanager.doc.Wiki;
import com.xpn.xwiki.plugin.wikimanager.doc.XWikiServer;
import com.xpn.xwiki.plugin.wikimanager.doc.XWikiServerClass;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiMessageTool;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.localization.ContextualLocalizationManager;

public class WikiManagerPluginApi
extends PluginApi<WikiManagerPlugin> {
    public static final String CONTEXT_LASTERRORCODE = "lasterrorcode";
    public static final String CONTEXT_LASTEXCEPTION = "lastexception";
    protected static final Logger LOGGER = LoggerFactory.getLogger(WikiManagerPluginApi.class);
    private XWikiExceptionApi defaultException;
    private GlobalSearchPluginApi searchApi;
    private WikiManager wikiManager;
    private ContextualLocalizationManager localizationManager;

    public WikiManagerPluginApi(WikiManagerPlugin plugin, XWikiContext context) {
        super((XWikiPluginInterface)plugin, context);
        this.defaultException = new XWikiExceptionApi((XWikiException)((Object)WikiManagerException.getDefaultException()), this.context);
        this.localizationManager = (ContextualLocalizationManager)Utils.getComponent(ContextualLocalizationManager.class);
        this.searchApi = plugin.getGlobalSearchApiPlugin(context);
        this.wikiManager = new WikiManager();
    }

    public XWikiExceptionApi getDefaultException() {
        return this.defaultException;
    }

    @Deprecated
    public XWikiMessageTool getMessageTool() {
        return WikiManagerMessageTool.getDefault(this.context);
    }

    public GlobalSearchPluginApi getSearchApi() {
        return this.searchApi;
    }

    private void error(String errorMessage, XWikiException e) {
        LOGGER.debug(errorMessage, (Throwable)e);
        this.context.put((Object)CONTEXT_LASTERRORCODE, (Object)e.getCode());
        this.context.put((Object)CONTEXT_LASTEXCEPTION, (Object)new XWikiExceptionApi(e, this.context));
    }

    public boolean canCreateWiki() {
        return this.wikiManager.canCreateWiki(this.context);
    }

    public boolean canEditWiki() {
        return this.wikiManager.canDeleteWiki(this.context);
    }

    public boolean canDeleteWiki() {
        return this.wikiManager.canEditWiki(this.context);
    }

    public int createNewWiki(String wikiName, String templateWiki, String pkgName, XWikiServer wikiXObjectDocument, boolean failOnExist) throws XWikiException {
        int returncode = -1;
        try {
            if (!this.canCreateWiki()) {
                throw new WikiManagerException(9001, this.localizationManager.getTranslationPlain("wikimanager.plugin.error.righttocreatewiki", new Object[]{wikiName}));
            }
            if (wikiName == null || wikiName.trim().equals("")) {
                throw new WikiManagerException(50036, this.localizationManager.getTranslationPlain("wikimanager.plugin.error.wikinameforbidden", new Object[]{wikiName}));
            }
            wikiXObjectDocument.setWikiName(wikiName);
            String realTemplateWikiName = templateWiki == null || templateWiki.trim().length() == 0 ? null : templateWiki;
            String realPkgName = pkgName == null || pkgName.trim().length() == 0 ? null : pkgName;
            String comment = "wikimanager.plugin.comment.createwiki";
            this.wikiManager.createNewWiki(wikiXObjectDocument, failOnExist, realTemplateWikiName, realPkgName, comment, this.context);
        }
        catch (WikiManagerException e) {
            this.error(this.localizationManager.getTranslationPlain("wikimanager.plugin.log.wikicreation", new Object[]{wikiXObjectDocument.toString()}), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int deleteWiki(String wikiName, boolean deleteDatabase) throws XWikiException {
        int returncode = -1;
        try {
            if (!this.canDeleteWiki()) {
                throw new WikiManagerException(9001, this.localizationManager.getTranslationPlain("wikimanager.plugin.error.righttodeletewiki", new Object[]{wikiName}));
            }
            this.wikiManager.deleteWiki(wikiName, deleteDatabase, this.context);
        }
        catch (WikiManagerException e) {
            this.error(this.localizationManager.getTranslationPlain("wikimanager.plugin.log.wikideletion", new Object[]{wikiName}), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int deleteWiki(String wikiName) throws XWikiException {
        return this.deleteWiki(wikiName, true);
    }

    @Deprecated
    public int deleteWiki(String wikiName, int objectId) throws XWikiException {
        return this.deleteWikiAlias(wikiName, objectId);
    }

    public int deleteWikiAlias(String wikiName, int objectId) throws XWikiException {
        int returncode = -1;
        try {
            if (!this.canEditWiki()) {
                throw new WikiManagerException(9001, this.localizationManager.getTranslationPlain("wikimanager.plugin.error.righttodeletewiki", new Object[]{wikiName}));
            }
            this.wikiManager.deleteWikiAlias(wikiName, objectId, this.context);
        }
        catch (WikiManagerException e) {
            this.error(this.localizationManager.getTranslationPlain("wikimanager.plugin.log.wikideletion", new Object[]{wikiName}), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public Wiki getWikiFromName(String wikiName) throws XWikiException {
        Wiki doc = null;
        try {
            doc = this.wikiManager.getWikiFromName(wikiName, this.context);
        }
        catch (WikiManagerException e) {
            this.error(this.localizationManager.getTranslationPlain("wikimanager.plugin.log.wikiget", new Object[]{wikiName}), (XWikiException)((Object)e));
        }
        return doc;
    }

    public List<Wiki> getAllWikis() throws XWikiException {
        List<Wiki> wikiList = Collections.emptyList();
        try {
            wikiList = this.wikiManager.getAllWikis(this.context);
        }
        catch (WikiManagerException e) {
            this.error(this.localizationManager.getTranslationPlain("wikimanager.plugin.log.wikigetall", new Object[0]), (XWikiException)((Object)e));
        }
        return wikiList;
    }

    public Wiki getWikiFromDocumentName(String documentFullName) throws XWikiException {
        Wiki doc = null;
        try {
            doc = this.wikiManager.getWikiFromDocumentName(documentFullName, this.context);
        }
        catch (WikiManagerException e) {
            this.error(this.localizationManager.getTranslationPlain("wikimanager.plugin.log.wikiget", new Object[]{documentFullName}), (XWikiException)((Object)e));
        }
        return doc;
    }

    public XWikiServer getWikiDocument(String wikiName) throws XWikiException {
        return this.getWikiDocument(wikiName, 0);
    }

    public XWikiServer getWikiDocument(String wikiName, int objectId) throws XWikiException {
        XWikiServer doc = null;
        try {
            doc = this.wikiManager.getWikiAlias(wikiName, objectId, true, this.context);
        }
        catch (WikiManagerException e) {
            this.error(this.localizationManager.getTranslationPlain("wikimanager.plugin.log.wikialiasget", new Object[]{wikiName}), (XWikiException)((Object)e));
        }
        return doc;
    }

    public List<XWikiServer> getWikiDocumentList() throws XWikiException {
        List<XWikiServer> listDocument = Collections.emptyList();
        try {
            listDocument = this.wikiManager.getWikiAliasList(this.context);
        }
        catch (WikiManagerException e) {
            this.error(this.localizationManager.getTranslationPlain("wikimanager.plugin.log.wikialiasgetall", new Object[0]), (XWikiException)((Object)e));
        }
        return listDocument;
    }

    public XWikiServer createWikiDocument() throws XWikiException {
        return (XWikiServer)XWikiServerClass.getInstance(this.context).newXObjectDocument(this.context);
    }

    public boolean isWikiExist(String wikiName) {
        return this.isWikiExist(wikiName, 0);
    }

    public boolean isWikiExist(String wikiName, int objectId) {
        return this.wikiManager.isWikiAliasExist(wikiName, objectId, this.context);
    }

    public boolean isWikiNameAvailable(String wikiName) throws XWikiException {
        return this.context.getWiki().getStore().isWikiNameAvailable(wikiName, this.context);
    }

    public int setWikiVisibility(String wikiName, String visibility) throws XWikiException {
        return this.setWikiVisibility(wikiName, 0, visibility);
    }

    public int setWikiVisibility(String wikiName, int objectId, String visibility) throws XWikiException {
        int returncode = -1;
        try {
            XWikiServer wikiAlias = this.wikiManager.getWikiAlias(wikiName, objectId, true, this.context);
            wikiAlias.setVisibility(visibility);
            wikiAlias.save();
        }
        catch (WikiManagerException e) {
            this.error(this.localizationManager.getTranslationPlain("wikimanager.plugin.log.wikisetvisibility", new Object[]{wikiName}), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int setIsWikiTemplate(String wikiName, boolean isWikiTemplate) throws XWikiException {
        int returncode = -1;
        try {
            Wiki wiki = this.wikiManager.getWikiFromName(wikiName, this.context);
            XWikiServer wikiAlias = wiki.getFirstWikiAlias();
            wikiAlias.setIsWikiTemplate(isWikiTemplate);
            wikiAlias.save();
        }
        catch (WikiManagerException e) {
            this.error(this.localizationManager.getTranslationPlain("wikimanager.plugin.log.wikisetvisibility", new Object[]{wikiName}), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public int createWikiTemplate(String templateName, String templateDescription, String packageName) throws XWikiException {
        if (!this.hasAdminRights()) {
            return 9001;
        }
        int returncode = -1;
        XWikiServer wikiXObjectDocument = (XWikiServer)XWikiServerClass.getInstance(this.context).newXObjectDocument(this.context);
        wikiXObjectDocument.setWikiName(templateName);
        wikiXObjectDocument.setDescription(templateDescription);
        wikiXObjectDocument.setServer(templateName + ".template.local");
        wikiXObjectDocument.setState("active");
        wikiXObjectDocument.setOwner(this.context.getUser());
        try {
            Object[] params = new String[]{templateName, packageName};
            String message = this.localizationManager.getTranslationPlain("wikimanager.plugin.comment.createwikitemplate", params);
            this.wikiManager.createWikiTemplate(wikiXObjectDocument, packageName, message, this.context);
        }
        catch (WikiManagerException e) {
            this.error(this.localizationManager.getTranslationPlain("wikimanager.plugin.log.wikicreation", new Object[]{wikiXObjectDocument.toString()}), (XWikiException)((Object)e));
            returncode = e.getCode();
        }
        return returncode;
    }

    public XWikiServer getWikiTemplateDocument(String wikiName) throws XWikiException {
        return this.getWikiTemplateDocument(wikiName, 0);
    }

    public XWikiServer getWikiTemplateDocument(String wikiName, int objectId) throws XWikiException {
        XWikiServer doc = null;
        try {
            doc = this.wikiManager.getWikiTemplateAlias(wikiName, objectId, this.context, true);
        }
        catch (WikiManagerException e) {
            this.error(this.localizationManager.getTranslationPlain("wikimanager.plugin.log.wikitemplateget", new Object[]{wikiName}), (XWikiException)((Object)e));
        }
        return doc;
    }

    public List<XWikiServer> getWikiTemplateList() throws XWikiException {
        List<XWikiServer> listDocument = Collections.emptyList();
        try {
            listDocument = this.wikiManager.getWikiTemplateAliasList(this.context);
        }
        catch (WikiManagerException e) {
            this.error(this.localizationManager.getTranslationPlain("wikimanager.plugin.log.wikitemplategetall", new Object[0]), (XWikiException)((Object)e));
        }
        return listDocument;
    }
}

