/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.script;

import com.xpn.xwiki.XWikiContext;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.script.service.ScriptServiceManager;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.url.internal.standard.StandardURLConfiguration;
import org.xwiki.wiki.configuration.WikiConfiguration;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.internal.descriptor.document.WikiDescriptorDocumentHelper;
import org.xwiki.wiki.manager.WikiManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="wiki")
@Singleton
public class WikiManagerScriptService
implements ScriptService {
    public static final String ROLEHINT = "wiki";
    @Deprecated
    public static final String CONTEXT_LASTEXCEPTION = "lastexception";
    private static final String WIKIERROR_KEY = "scriptservice.wiki.error";
    @Inject
    private WikiManager wikiManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Execution execution;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private ScriptServiceManager scriptServiceManager;
    @Inject
    private StandardURLConfiguration standardURLConfiguration;
    @Inject
    private WikiConfiguration wikiConfiguration;
    @Inject
    private WikiDescriptorDocumentHelper wikiDescriptorDocumentHelper;
    @Inject
    private Logger logger;

    public ScriptService get(String serviceName) {
        return this.scriptServiceManager.get("wiki." + serviceName);
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(WIKIERROR_KEY);
    }

    private void setLastError(Exception e) {
        this.execution.getContext().setProperty(WIKIERROR_KEY, (Object)e);
    }

    private void checkProgrammingRights() throws AuthorizationException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        this.authorizationManager.checkAccess(Right.PROGRAM, xcontext.getDoc().getAuthorReference(), (EntityReference)xcontext.getDoc().getDocumentReference());
    }

    public WikiDescriptor createWiki(String wikiId, String wikiAlias, String ownerId, boolean failOnExist) {
        WikiDescriptor descriptor = null;
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        try {
            this.checkProgrammingRights();
            WikiReference mainWikiReference = new WikiReference(this.getMainWikiId());
            this.authorizationManager.checkAccess(Right.CREATE_WIKI, context.getUserReference(), (EntityReference)mainWikiReference);
            if (!failOnExist) {
                this.authorizationManager.checkAccess(Right.PROGRAM, context.getUserReference(), (EntityReference)mainWikiReference);
            }
            descriptor = this.wikiManager.create(wikiId, wikiAlias, ownerId, failOnExist);
        }
        catch (Exception e) {
            this.error(e);
        }
        return descriptor;
    }

    public boolean deleteWiki(String wikiId) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        try {
            this.checkProgrammingRights();
            if (!this.canDeleteWiki((String)this.entityReferenceSerializer.serialize((EntityReference)context.getUserReference(), new Object[0]), wikiId)) {
                throw new AuthorizationException("You don't have the right to delete the wiki");
            }
            this.wikiManager.delete(wikiId);
            return true;
        }
        catch (Exception e) {
            this.error(String.format("Failed to delete wiki [%s]", wikiId), e);
            return false;
        }
    }

    public boolean canDeleteWiki(String userId, String wikiId) {
        try {
            String owner;
            WikiDescriptor descriptor = this.wikiDescriptorManager.getById(wikiId);
            if (descriptor == null) {
                this.error(new Exception(String.format("Could not find descriptor for wiki [%s]]", wikiId)));
                return false;
            }
            DocumentReference userReference = this.documentReferenceResolver.resolve((Object)userId, new Object[0]);
            String fullUserId = (String)this.entityReferenceSerializer.serialize((EntityReference)userReference, new Object[0]);
            if (fullUserId.equals(owner = descriptor.getOwnerId())) {
                return true;
            }
            WikiReference wikiReference = new WikiReference(wikiId);
            if (this.authorizationManager.hasAccess(Right.ADMIN, userReference, (EntityReference)wikiReference)) {
                return true;
            }
        }
        catch (WikiManagerException e) {
            this.error(String.format("Error while getting the descriptor of wiki [%s]", wikiId), (Exception)((Object)e));
        }
        return false;
    }

    public WikiDescriptor getByAlias(String wikiAlias) {
        WikiDescriptor descriptor = null;
        try {
            descriptor = this.wikiDescriptorManager.getByAlias(wikiAlias);
        }
        catch (WikiManagerException e) {
            this.error((Exception)((Object)e));
        }
        return descriptor;
    }

    public WikiDescriptor getById(String wikiId) {
        WikiDescriptor descriptor = null;
        try {
            descriptor = this.wikiDescriptorManager.getById(wikiId);
        }
        catch (WikiManagerException e) {
            this.error((Exception)((Object)e));
        }
        return descriptor;
    }

    public Collection<WikiDescriptor> getAll() {
        ArrayList wikis;
        try {
            wikis = this.wikiDescriptorManager.getAll();
        }
        catch (WikiManagerException e) {
            this.error((Exception)((Object)e));
            wikis = new ArrayList();
        }
        return wikis;
    }

    public Collection<String> getAllIds() {
        ArrayList wikis;
        try {
            wikis = this.wikiDescriptorManager.getAllIds();
        }
        catch (WikiManagerException e) {
            this.error((Exception)((Object)e));
            wikis = new ArrayList();
        }
        return wikis;
    }

    public Boolean exists(String wikiId) {
        try {
            return this.wikiDescriptorManager.exists(wikiId);
        }
        catch (WikiManagerException e) {
            this.error((Exception)((Object)e));
            return null;
        }
    }

    public Boolean idAvailable(String wikiId) {
        try {
            return this.wikiManager.idAvailable(wikiId);
        }
        catch (WikiManagerException e) {
            this.error((Exception)((Object)e));
            return null;
        }
    }

    public WikiDescriptor getMainWikiDescriptor() {
        WikiDescriptor descriptor = null;
        try {
            descriptor = this.wikiDescriptorManager.getMainWikiDescriptor();
        }
        catch (WikiManagerException e) {
            this.error((Exception)((Object)e));
        }
        return descriptor;
    }

    public String getMainWikiId() {
        return this.wikiDescriptorManager.getMainWikiId();
    }

    public String getCurrentWikiId() {
        return this.wikiDescriptorManager.getCurrentWikiId();
    }

    public WikiDescriptor getCurrentWikiDescriptor() {
        WikiDescriptor descriptor = null;
        try {
            descriptor = this.wikiDescriptorManager.getCurrentWikiDescriptor();
        }
        catch (WikiManagerException e) {
            this.error((Exception)((Object)e));
        }
        return descriptor;
    }

    public boolean saveDescriptor(WikiDescriptor descriptor) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        try {
            boolean isAllowed;
            WikiDescriptor oldDescriptor = this.wikiDescriptorManager.getById(descriptor.getId());
            WikiReference wikiReference = descriptor.getReference();
            if (oldDescriptor != null) {
                DocumentReference descriptorDocument = this.wikiDescriptorDocumentHelper.getDocumentReferenceFromId(oldDescriptor.getId());
                isAllowed = this.authorizationManager.hasAccess(Right.EDIT, context.getUserReference(), (EntityReference)descriptorDocument);
                String currentOwner = oldDescriptor.getOwnerId();
                if (!isAllowed) {
                    isAllowed = ((String)this.entityReferenceSerializer.serialize((EntityReference)context.getUserReference(), new Object[0])).equals(currentOwner);
                }
                if (!isAllowed) {
                    String newOwner = descriptor.getOwnerId();
                    isAllowed = this.authorizationManager.hasAccess(Right.ADMIN, context.getUserReference(), (EntityReference)wikiReference) && StringUtils.equals((CharSequence)newOwner, (CharSequence)currentOwner);
                }
            } else {
                isAllowed = this.authorizationManager.hasAccess(Right.ADMIN, context.getUserReference(), (EntityReference)new WikiReference(this.wikiDescriptorManager.getMainWikiId()));
            }
            if (!isAllowed) {
                throw new AccessDeniedException(context.getUserReference(), (EntityReference)wikiReference);
            }
            this.wikiDescriptorManager.saveDescriptor(descriptor);
            return true;
        }
        catch (Exception e) {
            this.error(e);
            return false;
        }
    }

    public boolean isPathMode() {
        return this.standardURLConfiguration.isPathBasedMultiWiki();
    }

    public String getAliasSuffix() {
        return this.wikiConfiguration.getAliasSuffix();
    }

    private void error(Exception e) {
        this.error(null, e);
    }

    private void error(String errorMessage, Exception e) {
        String errorMessageToLog = errorMessage;
        if (errorMessageToLog == null) {
            errorMessageToLog = e.getMessage();
        }
        this.logger.error(errorMessageToLog, (Throwable)e);
        this.setLastError(e);
        this.execution.getContext().setProperty(CONTEXT_LASTEXCEPTION, (Object)e);
    }

    @Deprecated
    public Exception getLastException() {
        return (Exception)this.execution.getContext().getProperty(CONTEXT_LASTEXCEPTION);
    }
}

