/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.template.internal;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.bridge.event.WikiCopiedEvent;
import org.xwiki.bridge.event.WikiProvisionedEvent;
import org.xwiki.bridge.event.WikiProvisioningEvent;
import org.xwiki.bridge.event.WikiProvisioningFailedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.DefaultJobStatus;
import org.xwiki.observation.event.Event;
import org.xwiki.wiki.manager.WikiManagerException;
import org.xwiki.wiki.provisioning.WikiCopier;
import org.xwiki.wiki.provisioning.WikiProvisioningJob;
import org.xwiki.wiki.provisioning.WikiProvisioningJobRequest;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="wikiprovisioning.template")
public class TemplateWikiProvisioningJob
extends AbstractJob<WikiProvisioningJobRequest, DefaultJobStatus<WikiProvisioningJobRequest>>
implements WikiProvisioningJob {
    public static final String JOBTYPE = "wikiprovisioning.template";
    @Inject
    private WikiCopier wikiCopier;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    protected void runInternal() throws Exception {
        WikiProvisioningJobRequest request = (WikiProvisioningJobRequest)this.getRequest();
        if (!(request.getProvisioningJobParameter() instanceof String)) {
            throw new Exception("The provisioning parameter is not a valid String.");
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        String wikiId = request.getWikiId();
        String templateId = (String)request.getProvisioningJobParameter();
        xcontext.setUserReference(request.getProvisioningUser());
        try {
            this.observationManager.notify((Event)new WikiProvisioningEvent(wikiId), (Object)wikiId, (Object)xcontext);
            this.wikiCopier.copyDocuments(templateId, wikiId, false);
            this.observationManager.notify((Event)new WikiProvisionedEvent(wikiId), (Object)wikiId, (Object)xcontext);
            this.observationManager.notify((Event)new WikiCopiedEvent(templateId, wikiId), (Object)templateId, (Object)xcontext);
        }
        catch (WikiManagerException e) {
            this.logger.error("Failed to provision wiki [{}] from template [{}].", new Object[]{wikiId, templateId, e});
            this.observationManager.notify((Event)new WikiProvisioningFailedEvent(wikiId), (Object)wikiId, (Object)xcontext);
        }
    }

    public String getType() {
        return JOBTYPE;
    }
}

