/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.user.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.AbstractMandatoryDocumentInitializer;
import com.xpn.xwiki.objects.classes.BaseClass;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.wiki.user.MembershipType;
import org.xwiki.wiki.user.UserScope;

@Component
@Named(value="WikiManager.WikiUserClass")
@Singleton
public class WikiUserClassDocumentInitializer
extends AbstractMandatoryDocumentInitializer {
    public static final String DOCUMENT_NAME = "WikiUserClass";
    public static final String DOCUMENT_SPACE = "WikiManager";
    public static final EntityReference CONFIGURATION_CLASS = new EntityReference("WikiUserClass", EntityType.DOCUMENT, new EntityReference("WikiManager", EntityType.SPACE));
    public static final String DEFAULT_FIELDS_SEPARATOR = "|";
    public static final String FIELD_MEMBERSHIPTYPE = "membershipType";
    public static final String FIELDPN_MEMBERSHIPTYPE = "Membership Type";
    public static final String FIELDL_MEMBERSHIPTYPE = MembershipType.OPEN.name().toLowerCase() + "|" + MembershipType.REQUEST.name().toLowerCase() + "|" + MembershipType.INVITE.name().toLowerCase();
    public static final String FIELDDT_MEMBERSHIPTYPE = "radio";
    public static final String FIELD_USERSCOPE = "userScope";
    public static final String FIELDPN_USERSCOPE = "User scope";
    public static final String FIELDDT_USERSCOPE = "radio";
    public static final String FIELDL_USERSCOPE = UserScope.GLOBAL_ONLY.name().toLowerCase() + "|" + UserScope.LOCAL_ONLY.name().toLowerCase() + "|" + UserScope.LOCAL_AND_GLOBAL.name().toLowerCase();

    public WikiUserClassDocumentInitializer() {
        super(DOCUMENT_SPACE, DOCUMENT_NAME);
    }

    public boolean updateDocument(XWikiDocument document) {
        boolean needsUpdate = false;
        BaseClass baseClass = document.getXClass();
        needsUpdate |= baseClass.addStaticListField(FIELD_MEMBERSHIPTYPE, FIELDPN_MEMBERSHIPTYPE, MembershipType.values().length, false, FIELDL_MEMBERSHIPTYPE, "radio");
        needsUpdate |= baseClass.addStaticListField(FIELD_USERSCOPE, FIELDPN_USERSCOPE, UserScope.values().length, false, FIELDL_USERSCOPE, "radio");
        if (!document.isHidden().booleanValue()) {
            document.setHidden(Boolean.valueOf(true));
            needsUpdate = true;
        }
        if (document.isNew()) {
            needsUpdate |= this.setClassDocumentFields(document, "Wiki User Class");
            document.setContent(document.getContent() + "\n\nClass that represents the wiki configuration" + " about users.");
        }
        return needsUpdate;
    }
}

