/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.user.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.AbstractMandatoryDocumentInitializer;
import com.xpn.xwiki.objects.classes.BaseClass;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;

@Component
@Named(value="WikiManager.WikiCandidateMemberClass")
@Singleton
public class WikiCandidateMemberClassInitializer
extends AbstractMandatoryDocumentInitializer {
    public static final String DOCUMENT_NAME = "WikiCandidateMemberClass";
    public static final String DOCUMENT_SPACE = "WikiManager";
    public static final LocalDocumentReference REFERENCE = new LocalDocumentReference("WikiManager", "WikiCandidateMemberClass");
    public static final String FIELD_USER = "userName";
    public static final String FIELDPN_USERNAME = "User Name";
    public static final String FIELD_DATE_OF_CREATION = "date";
    public static final String FIELDPN_DATE = "Date";
    public static final String FIELD_USER_COMMENT = "userComment";
    public static final String FIELDPN_USERCOMMENT = "User Comment";
    public static final String FIELD_STATUS = "status";
    public static final String FIELDPN_STATUS = "Status";
    public static final String FIELDL_STATUS = "pending=Pending|accepted=Accepted|rejected=Rejected";
    public static final String FIELD_DATE_OF_CLOSURE = "resolutionDate";
    public static final String FIELDPN_RESOLUTIONDATE = "Resolution Date";
    public static final String FIELD_ADMIN = "reviewer";
    public static final String FIELDPN_REVIEWER = "Reviewer";
    public static final String FIELD_ADMIN_COMMENT = "reviewerComment";
    public static final String FIELDPN_REVIEWERCOMMENT = "Reviewer's Comment";
    public static final String FIELD_ADMIN_PRIVATE_COMMENT = "reviewerPrivateComment";
    public static final String FIELDPN_REVIEWERPRIVATECOMMENT = "Reviewer's Private Reason";
    public static final String FIELD_TYPE = "type";
    public static final String FIELDPN_TYPE = "Type";
    public static final String FIELDL_TYPE = "request=Request|invitation=Invitation";

    public WikiCandidateMemberClassInitializer() {
        super((EntityReference)REFERENCE);
    }

    public boolean updateDocument(XWikiDocument document) {
        boolean needsUpdate = false;
        BaseClass baseClass = document.getXClass();
        needsUpdate |= baseClass.addTextField(FIELD_USER, FIELDPN_USERNAME, 30);
        needsUpdate |= baseClass.addDateField(FIELD_DATE_OF_CREATION, FIELDPN_DATE);
        needsUpdate |= baseClass.addTextAreaField(FIELD_USER_COMMENT, FIELDPN_USERCOMMENT, 40, 3);
        needsUpdate |= baseClass.addStaticListField(FIELD_STATUS, FIELDPN_STATUS, FIELDL_STATUS);
        needsUpdate |= baseClass.addDateField(FIELD_DATE_OF_CLOSURE, FIELDPN_RESOLUTIONDATE);
        needsUpdate |= baseClass.addTextField(FIELD_ADMIN, FIELDPN_REVIEWER, 30);
        needsUpdate |= baseClass.addTextAreaField(FIELD_ADMIN_COMMENT, FIELDPN_REVIEWERCOMMENT, 40, 3);
        needsUpdate |= baseClass.addTextAreaField(FIELD_ADMIN_PRIVATE_COMMENT, FIELDPN_REVIEWERPRIVATECOMMENT, 40, 3);
        needsUpdate |= baseClass.addStaticListField(FIELD_TYPE, FIELDPN_TYPE, FIELDL_TYPE);
        if (!document.isHidden().booleanValue()) {
            document.setHidden(Boolean.valueOf(true));
            needsUpdate = true;
        }
        if (document.isNew()) {
            needsUpdate |= this.setClassDocumentFields(document, "Wiki Candidate Member Class");
            document.setContent(document.getContent() + "\n\nClass that represents a candidacy to become a member " + "of the wiki.");
        }
        return needsUpdate;
    }
}

