/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.user.script;

import com.xpn.xwiki.XWikiContext;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.stability.Unstable;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.user.MemberCandidacy;
import org.xwiki.wiki.user.MembershipType;
import org.xwiki.wiki.user.UserScope;
import org.xwiki.wiki.user.WikiUserManager;
import org.xwiki.wiki.user.WikiUserManagerException;
import org.xwiki.wiki.user.script.WikiUserManagerScriptServiceException;

@Component
@Named(value="wiki.user")
@Singleton
@Unstable
public class WikiUserManagerScriptService
implements ScriptService {
    private static final String WIKIUSERERROR_KEY = "scriptservice.wiki.user.error";
    @Inject
    private WikiUserManager wikiUserManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private Execution execution;

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(WIKIUSERERROR_KEY);
    }

    private void setLastError(Exception e) {
        this.execution.getContext().setProperty(WIKIUSERERROR_KEY, (Object)e);
    }

    public UserScope getUserScope() {
        return this.getUserScope(this.wikiDescriptorManager.getCurrentWikiId());
    }

    public UserScope getUserScope(String wikiId) {
        try {
            return this.wikiUserManager.getUserScope(wikiId);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return null;
        }
    }

    public boolean setUserScope(String wikiId, String scope) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        boolean success = true;
        try {
            this.authorizationManager.checkAccess(Right.PROGRAM, xcontext.getDoc().getAuthorReference(), (EntityReference)xcontext.getDoc().getDocumentReference());
            this.authorizationManager.checkAccess(Right.ADMIN, xcontext.getUserReference(), (EntityReference)new WikiReference(wikiId));
            this.wikiUserManager.setUserScope(wikiId, UserScope.valueOf((String)scope.toUpperCase()));
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            success = false;
        }
        catch (AccessDeniedException e) {
            this.setLastError((Exception)((Object)e));
            success = false;
        }
        catch (IllegalArgumentException e) {
            this.setLastError(e);
            success = false;
        }
        return success;
    }

    public MembershipType getMembershipType() {
        return this.getMembershipType(this.wikiDescriptorManager.getCurrentWikiId());
    }

    public MembershipType getMembershipType(String wikiId) {
        try {
            return this.wikiUserManager.getMembershipType(wikiId);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return null;
        }
    }

    public boolean setMembershipType(String wikiId, String type) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        boolean success = true;
        try {
            this.authorizationManager.checkAccess(Right.PROGRAM, xcontext.getDoc().getAuthorReference(), (EntityReference)xcontext.getDoc().getDocumentReference());
            this.authorizationManager.checkAccess(Right.ADMIN, xcontext.getUserReference(), (EntityReference)new WikiReference(wikiId));
            this.wikiUserManager.setMembershipType(wikiId, MembershipType.valueOf((String)type.toUpperCase()));
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            success = false;
        }
        catch (AccessDeniedException e) {
            this.setLastError((Exception)((Object)e));
            success = false;
        }
        catch (IllegalArgumentException e) {
            this.setLastError(e);
            success = false;
        }
        return success;
    }

    public Collection<String> getMembers(String wikiId) {
        try {
            return this.wikiUserManager.getMembers(wikiId);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return null;
        }
    }

    public Boolean isMember(String userId, String wikiId) {
        try {
            return this.wikiUserManager.isMember(userId, wikiId);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return null;
        }
    }

    public boolean addMember(String userId, String wikiId) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            this.authorizationManager.checkAccess(Right.PROGRAM, xcontext.getDoc().getAuthorReference(), (EntityReference)xcontext.getDoc().getDocumentReference());
            this.authorizationManager.checkAccess(Right.ADMIN, xcontext.getUserReference(), (EntityReference)new WikiReference(wikiId));
            this.wikiUserManager.addMember(userId, wikiId);
        }
        catch (AccessDeniedException e) {
            this.setLastError((Exception)((Object)e));
            return false;
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return false;
        }
        return true;
    }

    public boolean addMembers(Collection<String> userIds, String wikiId) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            this.authorizationManager.checkAccess(Right.PROGRAM, xcontext.getDoc().getAuthorReference(), (EntityReference)xcontext.getDoc().getDocumentReference());
            this.authorizationManager.checkAccess(Right.ADMIN, xcontext.getUserReference(), (EntityReference)new WikiReference(wikiId));
            this.wikiUserManager.addMembers(userIds, wikiId);
        }
        catch (AccessDeniedException e) {
            this.setLastError((Exception)((Object)e));
            return false;
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return false;
        }
        return true;
    }

    public boolean removeMember(String userId, String wikiId) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            this.authorizationManager.checkAccess(Right.PROGRAM, xcontext.getDoc().getAuthorReference(), (EntityReference)xcontext.getDoc().getDocumentReference());
            this.authorizationManager.checkAccess(Right.ADMIN, xcontext.getUserReference(), (EntityReference)new WikiReference(wikiId));
            this.wikiUserManager.removeMember(userId, wikiId);
        }
        catch (AccessDeniedException e) {
            this.setLastError((Exception)((Object)e));
            return false;
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return false;
        }
        return true;
    }

    private boolean canSeeCandidacy(MemberCandidacy candidacy) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        String currentUser = (String)this.entityReferenceSerializer.serialize((EntityReference)xcontext.getUserReference(), new Object[0]);
        if (candidacy.getUserId().equals(currentUser)) {
            candidacy.setAdminPrivateComment(null);
            return true;
        }
        return this.authorizationManager.hasAccess(Right.ADMIN, xcontext.getUserReference(), (EntityReference)new WikiReference(candidacy.getWikiId()));
    }

    public MemberCandidacy getCandidacy(String wikiId, int candidacyId) {
        MemberCandidacy candidacy = null;
        try {
            candidacy = this.wikiUserManager.getCandidacy(wikiId, candidacyId);
            if (!this.canSeeCandidacy(candidacy)) {
                this.setLastError(new WikiUserManagerScriptServiceException("You are not allowed to see this candidacy."));
                candidacy = null;
            }
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
        }
        return candidacy;
    }

    private Collection<MemberCandidacy> filterAuthorizedCandidacies(Collection<MemberCandidacy> candidacies) {
        ArrayList<MemberCandidacy> authorizedCandidacies = new ArrayList<MemberCandidacy>();
        for (MemberCandidacy candidacy : candidacies) {
            if (!this.canSeeCandidacy(candidacy)) continue;
            authorizedCandidacies.add(candidacy);
        }
        return authorizedCandidacies;
    }

    public Collection<MemberCandidacy> getAllInvitations(String wikiId) {
        try {
            Collection candidacies = this.wikiUserManager.getAllInvitations(wikiId);
            return this.filterAuthorizedCandidacies(candidacies);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return null;
        }
    }

    public Boolean hasPendingInvitation(DocumentReference user, String wikiId) {
        if (user == null) {
            return false;
        }
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            this.authorizationManager.checkAccess(Right.PROGRAM, xcontext.getDoc().getAuthorReference(), (EntityReference)xcontext.getDoc().getDocumentReference());
            if (!xcontext.getUserReference().equals((Object)user)) {
                this.authorizationManager.checkAccess(Right.ADMIN, xcontext.getUserReference(), (EntityReference)new WikiReference(wikiId));
            }
            return this.wikiUserManager.hasPendingInvitation(user, wikiId);
        }
        catch (AccessDeniedException e) {
            this.setLastError((Exception)((Object)e));
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
        }
        return null;
    }

    public Boolean hasPendingRequest(DocumentReference user, String wikiId) {
        if (user == null) {
            return false;
        }
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            this.authorizationManager.checkAccess(Right.PROGRAM, xcontext.getDoc().getAuthorReference(), (EntityReference)xcontext.getDoc().getDocumentReference());
            if (!xcontext.getUserReference().equals((Object)user)) {
                this.authorizationManager.checkAccess(Right.ADMIN, xcontext.getUserReference(), (EntityReference)new WikiReference(wikiId));
            }
            return this.wikiUserManager.hasPendingRequest(user, wikiId);
        }
        catch (AccessDeniedException e) {
            this.setLastError((Exception)((Object)e));
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
        }
        return null;
    }

    public Collection<MemberCandidacy> getAllRequests(String wikiId) {
        try {
            Collection candidacies = this.wikiUserManager.getAllRequests(wikiId);
            return this.filterAuthorizedCandidacies(candidacies);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return null;
        }
    }

    public boolean join(String userId, String wikiId) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        String currentUser = (String)this.entityReferenceSerializer.serialize((EntityReference)xcontext.getUserReference(), new Object[0]);
        if (!userId.equals(currentUser)) {
            this.setLastError((Exception)((Object)new WikiUserManagerException(String.format("User [%s] cannot call $services.wiki.user.join() with an other userId.", currentUser))));
            return false;
        }
        try {
            this.wikiUserManager.join(userId, wikiId);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return false;
        }
        return true;
    }

    public boolean leave(String userId, String wikiId) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        String currentUser = (String)this.entityReferenceSerializer.serialize((EntityReference)xcontext.getUserReference(), new Object[0]);
        if (!userId.equals(currentUser)) {
            this.setLastError((Exception)((Object)new WikiUserManagerException(String.format("User [%s] cannot call $services.wiki.user.leave() with an other userId.", currentUser))));
            return false;
        }
        try {
            this.wikiUserManager.leave(userId, wikiId);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return false;
        }
        return true;
    }

    public MemberCandidacy askToJoin(String userId, String wikiId, String message) {
        try {
            return this.wikiUserManager.askToJoin(userId, wikiId, message);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return null;
        }
    }

    public boolean acceptRequest(MemberCandidacy request, String message, String privateComment) {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            this.authorizationManager.checkAccess(Right.PROGRAM, xcontext.getDoc().getAuthorReference(), (EntityReference)xcontext.getDoc().getDocumentReference());
            this.authorizationManager.checkAccess(Right.ADMIN, xcontext.getUserReference(), (EntityReference)new WikiReference(request.getWikiId()));
            this.wikiUserManager.acceptRequest(request, message, privateComment);
            return true;
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
        }
        catch (AccessDeniedException e) {
            this.setLastError((Exception)((Object)e));
        }
        return false;
    }

    public boolean refuseRequest(MemberCandidacy request, String message, String privateComment) {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            this.authorizationManager.checkAccess(Right.PROGRAM, xcontext.getDoc().getAuthorReference(), (EntityReference)xcontext.getDoc().getDocumentReference());
            this.authorizationManager.checkAccess(Right.ADMIN, xcontext.getUserReference(), (EntityReference)new WikiReference(request.getWikiId()));
            this.wikiUserManager.refuseRequest(request, message, privateComment);
            return true;
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
        }
        catch (AccessDeniedException e) {
            this.setLastError((Exception)((Object)e));
        }
        return false;
    }

    public boolean cancelCandidacy(MemberCandidacy candidacy) {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            this.authorizationManager.checkAccess(Right.PROGRAM, xcontext.getDoc().getAuthorReference(), (EntityReference)xcontext.getDoc().getDocumentReference());
            String currentUser = (String)this.entityReferenceSerializer.serialize((EntityReference)xcontext.getUserReference(), new Object[0]);
            if (!candidacy.getUserId().equals(currentUser)) {
                this.authorizationManager.checkAccess(Right.ADMIN, xcontext.getUserReference(), (EntityReference)new WikiReference(candidacy.getWikiId()));
            }
            this.wikiUserManager.cancelCandidacy(candidacy);
            return true;
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
        }
        catch (AccessDeniedException e) {
            this.setLastError((Exception)((Object)e));
        }
        return false;
    }

    public MemberCandidacy invite(String userId, String wikiId, String message) {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            this.authorizationManager.checkAccess(Right.PROGRAM, xcontext.getDoc().getAuthorReference(), (EntityReference)xcontext.getDoc().getDocumentReference());
            this.authorizationManager.checkAccess(Right.ADMIN, xcontext.getUserReference(), (EntityReference)new WikiReference(wikiId));
            return this.wikiUserManager.invite(userId, wikiId, message);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
        }
        catch (AccessDeniedException e) {
            this.setLastError((Exception)((Object)e));
        }
        return null;
    }

    public boolean acceptInvitation(MemberCandidacy invitation, String message) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (!this.authorizationManager.hasAccess(Right.PROGRAM, xcontext.getDoc().getAuthorReference(), (EntityReference)xcontext.getDoc().getDocumentReference())) {
            return false;
        }
        if (!this.canSeeCandidacy(invitation)) {
            return false;
        }
        try {
            this.wikiUserManager.acceptInvitation(invitation, message);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return false;
        }
        return true;
    }

    public boolean refuseInvitation(MemberCandidacy invitation, String message) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (!this.authorizationManager.hasAccess(Right.PROGRAM, xcontext.getDoc().getAuthorReference(), (EntityReference)xcontext.getDoc().getDocumentReference())) {
            return false;
        }
        if (!this.canSeeCandidacy(invitation)) {
            return false;
        }
        try {
            this.wikiUserManager.refuseInvitation(invitation, message);
        }
        catch (WikiUserManagerException e) {
            this.setLastError((Exception)((Object)e));
            return false;
        }
        return true;
    }
}

