/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.descriptor;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xwiki.properties.BeanDescriptor;
import org.xwiki.properties.PropertyDescriptor;
import org.xwiki.stability.Unstable;
import org.xwiki.wikistream.descriptor.DefaultWikiStreamBeanParameterDescriptor;
import org.xwiki.wikistream.descriptor.WikiStreamBeanDescriptor;
import org.xwiki.wikistream.descriptor.WikiStreamPropertyDescriptor;

@Unstable
public class DefaultWikiStreamBeanDescriptor
implements WikiStreamBeanDescriptor {
    private String name;
    private String description;
    private BeanDescriptor propertiesBeanDescriptor;
    private Map<String, WikiStreamPropertyDescriptor<?>> parameterDescriptorMap = new LinkedHashMap();

    public DefaultWikiStreamBeanDescriptor(String name, String description, BeanDescriptor parametersBeanDescriptor) {
        this.name = name;
        this.description = description;
        this.propertiesBeanDescriptor = parametersBeanDescriptor;
    }

    protected void extractParameters() {
        for (PropertyDescriptor propertyDescriptor : this.propertiesBeanDescriptor.getProperties()) {
            DefaultWikiStreamBeanParameterDescriptor desc = new DefaultWikiStreamBeanParameterDescriptor(propertyDescriptor);
            this.parameterDescriptorMap.put(desc.getId().toLowerCase(), desc);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public <T> WikiStreamPropertyDescriptor<T> getPropertyDescriptor(String propertyName) {
        return this.parameterDescriptorMap.get(propertyName);
    }

    @Override
    public Collection<WikiStreamPropertyDescriptor<?>> getProperties() {
        return Collections.unmodifiableCollection(this.parameterDescriptorMap.values());
    }

    @Override
    public Class<?> getBeanClass() {
        return this.propertiesBeanDescriptor.getBeanClass();
    }
}

