/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.internal.input;

import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Inject;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.input.BeanInputWikiStreamFactory;
import org.xwiki.wikistream.input.InputWikiStream;
import org.xwiki.wikistream.internal.AbstractBeanWikiStreamFactory;
import org.xwiki.wikistream.internal.input.BeanInputWikiStream;
import org.xwiki.wikistream.type.WikiStreamType;

public abstract class AbstractBeanInputWikiStreamFactory<P>
extends AbstractBeanWikiStreamFactory<P>
implements BeanInputWikiStreamFactory<P>,
Initializable {
    @Inject
    private ComponentManager componentManager;

    public AbstractBeanInputWikiStreamFactory(WikiStreamType type) {
        super(type);
    }

    @Override
    public InputWikiStream createInputWikiStream(Map<String, Object> properties) throws WikiStreamException {
        return this.createInputWikiStream(this.createPropertiesBean(properties));
    }

    @Override
    public InputWikiStream createInputWikiStream(P properties) throws WikiStreamException {
        BeanInputWikiStream inputWikiStream;
        try {
            inputWikiStream = (BeanInputWikiStream)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, BeanInputWikiStream.class, new Type[]{properties.getClass()}), this.getType().serialize());
        }
        catch (ComponentLookupException e) {
            throw new WikiStreamException(String.format("Failed to get instance of [%s] for type [%s]", BeanInputWikiStream.class, this.getType()), e);
        }
        inputWikiStream.setProperties(properties);
        return inputWikiStream;
    }
}

