/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.type;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.stability.Unstable;
import org.xwiki.wikistream.type.WikiType;

@Unstable
public class WikiStreamType {
    public static final WikiStreamType WIKI_XML = new WikiStreamType(WikiType.WIKI, "xml");
    public static final WikiStreamType XWIKI_XAR = new WikiStreamType(WikiType.XWIKI, "xar", "1.0");
    public static final WikiStreamType XWIKI_INSTANCE = new WikiStreamType(WikiType.XWIKI, "instance");
    private WikiType type;
    private String dataFormat;
    private String version;

    public WikiStreamType(WikiType type, String dataFormat) {
        this(type, dataFormat, null);
    }

    public WikiStreamType(WikiType type, String dataFormat, String version) {
        this.type = type;
        this.dataFormat = dataFormat != null ? dataFormat.toLowerCase() : null;
        this.version = version;
    }

    public WikiType getType() {
        return this.type;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public String getVersion() {
        return this.version;
    }

    public String serialize() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getType().serialize());
        if (this.getDataFormat() != null) {
            builder.append('+');
            builder.append(this.getDataFormat());
        }
        if (this.getVersion() != null) {
            builder.append('/');
            builder.append(this.getVersion());
        }
        return builder.toString();
    }

    public static WikiStreamType unserialize(String str) {
        int dataIndex;
        if (str == null) {
            return null;
        }
        String wikiType = str;
        String data = null;
        String version = null;
        int versionIndex = str.lastIndexOf(47);
        if (versionIndex == 0) {
            throw new IllegalArgumentException("'/' is inavlid as first character: " + str);
        }
        if (versionIndex != -1) {
            version = wikiType.substring(versionIndex + 1);
            wikiType = wikiType.substring(0, versionIndex);
        }
        if ((dataIndex = str.indexOf(43)) == 0) {
            throw new IllegalArgumentException("'+' is invalid as first character: " + str);
        }
        if (dataIndex != -1) {
            data = wikiType.substring(dataIndex + 1);
            wikiType = wikiType.substring(0, dataIndex);
        }
        return new WikiStreamType(WikiType.unserialize(wikiType), data, version);
    }

    public String toString() {
        return this.serialize();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).append((Object)this.getDataFormat()).append((Object)this.getVersion()).toHashCode();
    }

    public boolean equals(Object object) {
        boolean result = this == object ? true : (object instanceof WikiStreamType ? ObjectUtils.equals((Object)this.getType(), (Object)((WikiStreamType)object).getType()) && ObjectUtils.equals((Object)this.getDataFormat(), (Object)((WikiStreamType)object).getDataFormat()) : false);
        return result;
    }
}

