/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.internal.input;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Inject;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.filter.FilterDescriptorManager;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.internal.input.BeanInputWikiStream;

public abstract class AbstractBeanInputWikiStream<P, F>
implements BeanInputWikiStream<P>,
Initializable {
    @Inject
    private FilterDescriptorManager filterDescriptorManager;
    protected Class<F> filterType;
    protected P properties;

    public AbstractBeanInputWikiStream() {
    }

    public AbstractBeanInputWikiStream(FilterDescriptorManager filterDescriptorManager, P properties) throws WikiStreamException {
        this.filterDescriptorManager = filterDescriptorManager;
        this.setProperties(properties);
    }

    @Override
    public void setProperties(P properties) throws WikiStreamException {
        this.properties = properties;
    }

    public void initialize() throws InitializationException {
        ParameterizedType genericType = (ParameterizedType)ReflectionUtils.resolveType(AbstractBeanInputWikiStream.class, this.getClass());
        this.filterType = ReflectionUtils.getTypeClass((Type)genericType.getActualTypeArguments()[1]);
    }

    @Override
    public void read(Object filter) throws WikiStreamException {
        Object proxyFilter = this.filterDescriptorManager.createFilterProxy(filter, new Class[]{this.filterType});
        this.read(filter, proxyFilter);
    }

    protected abstract void read(Object var1, F var2) throws WikiStreamException;
}

