/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.instance.internal.output;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.filter.FilterDescriptorManager;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.instance.internal.output.InstanceOutputProperties;
import org.xwiki.wikistream.instance.output.OutputInstanceWikiStreamFactory;
import org.xwiki.wikistream.internal.output.AbstractBeanOutputWikiStream;

@Component
@Named(value="xwiki+instance")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class InstanceOutputWikiStream
extends AbstractBeanOutputWikiStream<InstanceOutputProperties> {
    @Inject
    private FilterDescriptorManager filterManager;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManager;

    public void setProperties(InstanceOutputProperties properties) throws WikiStreamException {
        List factories;
        super.setProperties((Object)properties);
        try {
            factories = ((ComponentManager)this.componentManager.get()).getInstanceList(OutputInstanceWikiStreamFactory.class);
        }
        catch (ComponentLookupException e) {
            throw new WikiStreamException("Failed to get regsitered instance of OutputInstanceWikiStreamFactory components", (Throwable)e);
        }
        Object[] filters = new Object[factories.size()];
        int i = 0;
        for (OutputInstanceWikiStreamFactory factory : factories) {
            filters[i++] = factory.creaOutputWikiStream(properties).getFilter();
        }
        this.filter = this.filterManager.createCompositeFilter(filters);
    }

    public Object getFilter() throws WikiStreamException {
        return this.filter;
    }

    public void close() throws IOException {
    }
}

