/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.xar.internal.input;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xwiki.component.annotation.Component;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.xar.internal.XARClassModel;
import org.xwiki.wikistream.xar.internal.XARFilter;
import org.xwiki.wikistream.xar.internal.XARWikiStreamUtils;
import org.xwiki.wikistream.xar.internal.input.AbstractReader;
import org.xwiki.wikistream.xar.internal.input.ClassPropertyReader;
import org.xwiki.wikistream.xar.internal.input.XARXMLReader;

@Component
@Singleton
public class ClassReader
extends AbstractReader
implements XARXMLReader<WikiClass> {
    @Inject
    private XARXMLReader<ClassPropertyReader.WikiClassProperty> propertyReader;

    @Override
    public WikiClass read(XMLStreamReader xmlReader) throws XMLStreamException, WikiStreamException {
        WikiClass wikiClass = new WikiClass();
        xmlReader.nextTag();
        while (xmlReader.isStartElement()) {
            String elementName = xmlReader.getLocalName();
            if (wikiClass.name == null && "name".equals(elementName)) {
                wikiClass.name = xmlReader.getElementText();
            } else if (XARClassModel.CLASS_PARAMETERS.containsKey(elementName)) {
                Object wsValue;
                String value = xmlReader.getElementText();
                XARWikiStreamUtils.EventParameter parameter = XARClassModel.CLASS_PARAMETERS.get(elementName);
                if (parameter != null && (wsValue = this.convert(parameter.type, value)) != null) {
                    wikiClass.parameters.put((Object)parameter.name, wsValue);
                }
            } else {
                wikiClass.addProperty(this.propertyReader.read(xmlReader));
            }
            xmlReader.nextTag();
        }
        return wikiClass;
    }

    public static class WikiClass {
        public String name;
        public FilterEventParameters parameters = new FilterEventParameters();
        public Map<String, ClassPropertyReader.WikiClassProperty> properties = new LinkedHashMap<String, ClassPropertyReader.WikiClassProperty>();

        public void send(XARFilter proxyFilter) throws WikiStreamException {
            proxyFilter.beginWikiClass(this.parameters);
            for (ClassPropertyReader.WikiClassProperty property : this.properties.values()) {
                property.send(proxyFilter);
            }
            proxyFilter.endWikiClass(this.parameters);
        }

        public boolean isEmpty() {
            return this.properties.isEmpty();
        }

        public void addProperty(ClassPropertyReader.WikiClassProperty property) {
            this.properties.put(property.name, property);
        }
    }
}

