/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.xar.internal.input;

import java.util.Date;
import java.util.Locale;
import javax.inject.Inject;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxFactory;
import org.xwiki.wikistream.WikiStreamException;

public abstract class AbstractReader {
    @Inject
    protected SyntaxFactory syntaxFactory;

    protected Object convert(Class<?> type, String source) throws WikiStreamException {
        Object value = source;
        if (type == Locale.class) {
            value = this.toLocale(source);
        } else if (type == Date.class) {
            value = StringUtils.isNotEmpty((CharSequence)source) ? new Date(Long.parseLong(source)) : null;
        } else if (type == Boolean.class) {
            value = StringUtils.isNotEmpty((CharSequence)source) ? Boolean.valueOf(Boolean.valueOf(source)) : null;
        } else if (type == Syntax.class) {
            if (StringUtils.isNotEmpty((CharSequence)source)) {
                try {
                    value = this.syntaxFactory.createSyntaxFromIdString(source);
                }
                catch (ParseException e) {
                    throw new WikiStreamException(String.format("Failed to create Syntax istance for [%s]", source), (Throwable)e);
                }
            } else {
                value = null;
            }
        } else if (type == Integer.class) {
            value = StringUtils.isNotEmpty((CharSequence)source) ? Integer.valueOf(Integer.parseInt(source)) : null;
        }
        return value;
    }

    protected Locale toLocale(String value) {
        Locale locale = null;
        if (value != null) {
            locale = value.length() == 0 ? Locale.ROOT : LocaleUtils.toLocale((String)value);
        }
        return locale;
    }
}

