/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.xar.internal.input;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xwiki.component.annotation.Component;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.xar.internal.input.AbstractReader;
import org.xwiki.wikistream.xar.internal.input.XARInputFilter;
import org.xwiki.wikistream.xar.internal.input.XARXMLReader;

@Component
@Singleton
public class ClassPropertyReader
extends AbstractReader
implements XARXMLReader<WikiClassProperty> {
    @Override
    public WikiClassProperty read(XMLStreamReader xmlReader) throws XMLStreamException, WikiStreamException {
        WikiClassProperty wikiClassProperty = new WikiClassProperty();
        wikiClassProperty.name = xmlReader.getLocalName();
        xmlReader.nextTag();
        while (xmlReader.isStartElement()) {
            String elementName = xmlReader.getLocalName();
            String value = xmlReader.getElementText();
            if (elementName.equals("classType")) {
                wikiClassProperty.type = value;
            } else {
                wikiClassProperty.fields.put(elementName, value);
            }
            xmlReader.nextTag();
        }
        if (wikiClassProperty.type == null) {
            throw new WikiStreamException(String.format("No <classType> element found for property [%s]", wikiClassProperty.name));
        }
        return wikiClassProperty;
    }

    public static class WikiClassProperty {
        public String name;
        public String type;
        public FilterEventParameters parameters = new FilterEventParameters();
        public Map<String, String> fields = new LinkedHashMap<String, String>();

        public void send(XARInputFilter proxyFilter) throws WikiStreamException {
            proxyFilter.beginWikiClassProperty(this.name, this.type, this.parameters);
            for (Map.Entry<String, String> entry : this.fields.entrySet()) {
                proxyFilter.onWikiClassPropertyField(entry.getKey(), entry.getValue(), FilterEventParameters.EMPTY);
            }
            proxyFilter.endWikiClassProperty(this.name, this.type, this.parameters);
        }
    }
}

