/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.xar.internal.input;

import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.input.InputSource;
import org.xwiki.wikistream.input.InputStreamInputSource;
import org.xwiki.wikistream.input.ReaderInputSource;
import org.xwiki.wikistream.internal.input.AbstractBeanInputWikiStream;
import org.xwiki.wikistream.xar.input.XARInputProperties;
import org.xwiki.wikistream.xar.internal.input.DocumentLocaleReader;
import org.xwiki.wikistream.xar.internal.input.WikiReader;
import org.xwiki.wikistream.xar.internal.input.XARInputFilter;
import org.xwiki.wikistream.xml.input.SourceInputSource;

@Component
@Named(value="xwiki+xar/1.1")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class XARInputWikiStream
extends AbstractBeanInputWikiStream<XARInputProperties, XARInputFilter> {
    @Inject
    private Provider<WikiReader> wikiReaderProvider;
    @Inject
    private Provider<DocumentLocaleReader> documentLocaleReaderProvider;

    public void close() throws IOException {
        ((XARInputProperties)((Object)this.properties)).getSource().close();
    }

    protected void read(Object filter, XARInputFilter proxyFilter) throws WikiStreamException {
        InputSource inputSource = ((XARInputProperties)((Object)this.properties)).getSource();
        if (((XARInputProperties)((Object)this.properties)).isForceDocument() || inputSource instanceof ReaderInputSource || inputSource instanceof SourceInputSource) {
            this.readDocument(filter, proxyFilter);
        } else if (inputSource instanceof InputStreamInputSource) {
            Boolean iszip;
            InputStream stream;
            try {
                stream = ((InputStreamInputSource)inputSource).getInputStream();
            }
            catch (IOException e) {
                throw new WikiStreamException("Failed to get input stream", (Throwable)e);
            }
            try {
                iszip = this.isZip(stream);
            }
            catch (IOException e) {
                throw new WikiStreamException("Failed to read input stream", (Throwable)e);
            }
            finally {
                try {
                    inputSource.close();
                }
                catch (IOException e) {
                    throw new WikiStreamException("Failed to close the source", (Throwable)e);
                }
            }
            if (iszip == Boolean.FALSE) {
                this.readDocument(filter, proxyFilter);
            } else {
                this.readXAR(filter, proxyFilter);
            }
        } else {
            throw new WikiStreamException(String.format("Unsupported input source of type [%s]", inputSource.getClass()));
        }
    }

    private void readXAR(Object filter, XARInputFilter proxyFilter) throws WikiStreamException {
        WikiReader wikiReader = (WikiReader)this.wikiReaderProvider.get();
        wikiReader.setProperties((XARInputProperties)((Object)this.properties));
        try {
            wikiReader.read(filter, proxyFilter);
        }
        catch (Exception e) {
            throw new WikiStreamException("Failed to read XAR package", (Throwable)e);
        }
    }

    protected void readDocument(Object filter, XARInputFilter proxyFilter) throws WikiStreamException {
        DocumentLocaleReader documentReader = (DocumentLocaleReader)this.documentLocaleReaderProvider.get();
        documentReader.setProperties((XARInputProperties)((Object)this.properties));
        try {
            documentReader.read(filter, proxyFilter);
        }
        catch (Exception e) {
            throw new WikiStreamException("Failed to read XAR XML document", (Throwable)e);
        }
        if (documentReader.getCurrentSpace() != null) {
            proxyFilter.endWikiSpace(documentReader.getCurrentSpace(), documentReader.getCurrentSpaceParameters());
        }
    }

    private Boolean isZip(InputStream stream) throws IOException {
        if (!stream.markSupported()) {
            return null;
        }
        byte[] signature = new byte[12];
        stream.mark(signature.length);
        int signatureLength = stream.read(signature);
        stream.reset();
        return ZipArchiveInputStream.matches((byte[])signature, (int)signatureLength);
    }
}

