/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.xml.internal.input;

import java.io.IOException;
import javanet.staxutils.XMLStreamUtils;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.input.InputSource;
import org.xwiki.wikistream.input.InputStreamInputSource;
import org.xwiki.wikistream.input.InputWikiStream;
import org.xwiki.wikistream.input.ReaderInputSource;
import org.xwiki.wikistream.xml.input.XMLInputProperties;

public abstract class AbstractXMLInputWikiStream<P extends XMLInputProperties>
implements InputWikiStream {
    protected P parameters;

    public AbstractXMLInputWikiStream(P parameters) {
        this.parameters = parameters;
    }

    public void read(Object listener) throws WikiStreamException {
        try {
            XMLEventReader xmlEventReader;
            InputSource source = ((XMLInputProperties)((Object)this.parameters)).getSource();
            if (source instanceof ReaderInputSource) {
                xmlEventReader = XMLInputFactory.newInstance().createXMLEventReader(((ReaderInputSource)source).getReader());
            } else if (source instanceof InputStreamInputSource) {
                xmlEventReader = XMLInputFactory.newInstance().createXMLEventReader(((InputStreamInputSource)source).getInputStream());
            } else {
                throw new WikiStreamException("Unknown source type [" + source.getClass() + "]");
            }
            XMLStreamUtils.copy((XMLEventReader)xmlEventReader, (XMLEventWriter)this.createXMLEventWriter(listener, this.parameters));
        }
        catch (Exception e) {
            throw new WikiStreamException("Faild to parse XML source", (Throwable)e);
        }
    }

    protected abstract XMLEventWriter createXMLEventWriter(Object var1, P var2);

    public void close() throws IOException {
        ((XMLInputProperties)((Object)this.parameters)).getSource().close();
    }
}

