/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.xml.internal.output;

import java.io.IOException;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.stax.StAXResult;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.output.OutputStreamOutputTarget;
import org.xwiki.wikistream.output.OutputTarget;
import org.xwiki.wikistream.output.OutputWikiStream;
import org.xwiki.wikistream.output.WriterOutputTarget;
import org.xwiki.wikistream.xml.output.ResultOutputTarget;
import org.xwiki.wikistream.xml.output.XMLOutputProperties;

public abstract class AbstractXMLOutputWikiStream<P extends XMLOutputProperties>
implements OutputWikiStream {
    protected final P properties;
    protected final Result result;
    protected Object filter;

    public AbstractXMLOutputWikiStream(P properties) throws WikiStreamException, XMLStreamException, IOException {
        this.properties = properties;
        this.result = this.createResult(this.properties);
    }

    protected Result createResult(P properties) throws WikiStreamException, XMLStreamException, IOException {
        Result result;
        OutputTarget target = ((XMLOutputProperties)((Object)properties)).getTarget();
        if (target instanceof ResultOutputTarget) {
            result = ((ResultOutputTarget)target).getResult();
        } else {
            XMLStreamWriter xmlStreamWriter;
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            if (target instanceof WriterOutputTarget) {
                xmlStreamWriter = factory.createXMLStreamWriter(((WriterOutputTarget)target).getWriter());
            } else if (target instanceof OutputStreamOutputTarget) {
                xmlStreamWriter = factory.createXMLStreamWriter(((OutputStreamOutputTarget)target).getOutputStream(), ((XMLOutputProperties)((Object)properties)).getEncoding());
            } else {
                throw new WikiStreamException("Unknown target type [" + target.getClass() + "]");
            }
            if (((XMLOutputProperties)((Object)properties)).isFormat()) {
                xmlStreamWriter = new IndentingXMLStreamWriter(xmlStreamWriter);
            }
            result = new StAXResult(xmlStreamWriter);
        }
        return result;
    }

    public Object getFilter() throws WikiStreamException {
        if (this.filter == null) {
            try {
                this.filter = this.createFilter(this.properties);
            }
            catch (Exception e) {
                throw new WikiStreamException("Failed to create filter", (Throwable)e);
            }
        }
        return this.filter;
    }

    protected abstract Object createFilter(P var1) throws XMLStreamException, FactoryConfigurationError, WikiStreamException;

    public void close() throws IOException {
        ((XMLOutputProperties)((Object)this.properties)).getTarget().close();
    }
}

