/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.xml.internal.output;

import java.io.OutputStream;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.xml.internal.output.XMLOutputWikiStreamUtils;
import org.xwiki.wikistream.xml.output.XMLOutputProperties;

public class WikiStreamXMLStreamWriter {
    private final XMLStreamWriter writer;
    private final boolean printNullValue;

    public WikiStreamXMLStreamWriter(XMLStreamWriter writer, boolean printNullValue) {
        this.writer = writer;
        this.printNullValue = printNullValue;
    }

    public WikiStreamXMLStreamWriter(OutputStream outputStream, String encoding, boolean format, boolean printNullValue) throws WikiStreamException {
        try {
            XMLStreamWriter streamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, encoding);
            this.writer = format ? new IndentingXMLStreamWriter(streamWriter) : streamWriter;
        }
        catch (Exception e) {
            throw new WikiStreamException("Failed to create XML writer", (Throwable)e);
        }
        this.printNullValue = printNullValue;
    }

    public WikiStreamXMLStreamWriter(XMLOutputProperties properties, boolean printNullValue) throws WikiStreamException {
        try {
            this.writer = XMLOutputWikiStreamUtils.createXMLStreamWriter(properties);
        }
        catch (Exception e) {
            throw new WikiStreamException("Failed to create XML writer", (Throwable)e);
        }
        this.printNullValue = printNullValue;
    }

    public XMLStreamWriter getWriter() {
        return this.writer;
    }

    public void writeStartDocument() throws WikiStreamException {
        try {
            this.writer.writeStartDocument();
        }
        catch (XMLStreamException e) {
            throw new WikiStreamException("Failed to write start document", (Throwable)e);
        }
    }

    public void writeStartDocument(String encoding, String version) throws WikiStreamException {
        try {
            this.writer.writeStartDocument(encoding, version);
        }
        catch (XMLStreamException e) {
            throw new WikiStreamException("Failed to write start document", (Throwable)e);
        }
    }

    public void writeEndDocument() throws WikiStreamException {
        try {
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new WikiStreamException("Failed to write end document", (Throwable)e);
        }
    }

    public void writeEmptyElement(String localName) throws WikiStreamException {
        try {
            this.writer.writeEmptyElement(localName);
        }
        catch (XMLStreamException e) {
            throw new WikiStreamException("Failed to write element", (Throwable)e);
        }
    }

    public void writeElement(String localName, String value) throws WikiStreamException {
        if (value != null) {
            if (value.isEmpty()) {
                this.writeEmptyElement(localName);
            } else {
                this.writeStartElement(localName);
                this.writeCharacters(value);
                this.writeEndElement();
            }
        } else if (this.printNullValue) {
            this.writeEmptyElement(localName);
        }
    }

    public void writeCharacters(String text) throws WikiStreamException {
        try {
            this.writer.writeCharacters(text);
        }
        catch (XMLStreamException e) {
            throw new WikiStreamException("Failed to write element", (Throwable)e);
        }
    }

    public void writeStartElement(String localName) throws WikiStreamException {
        try {
            this.writer.writeStartElement(localName);
        }
        catch (XMLStreamException e) {
            throw new WikiStreamException("Failed to write element", (Throwable)e);
        }
    }

    public void writeEndElement() throws WikiStreamException {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new WikiStreamException("Failed to write element", (Throwable)e);
        }
    }

    public void writeAttribute(String localName, String value) throws WikiStreamException {
        if (value != null) {
            try {
                this.writer.writeAttribute(localName, value);
            }
            catch (XMLStreamException e) {
                throw new WikiStreamException("Failed to write attribute", (Throwable)e);
            }
        }
    }

    public void writeCharacters(char[] text, int start, int len) throws WikiStreamException {
        try {
            this.writer.writeCharacters(text, start, len);
        }
        catch (XMLStreamException e) {
            throw new WikiStreamException("Failed to write characters", (Throwable)e);
        }
    }

    public void close() throws WikiStreamException {
        try {
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new WikiStreamException("Failed to close writer", (Throwable)e);
        }
    }

    public void flush() throws WikiStreamException {
        try {
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            throw new WikiStreamException("Failed to flush writer", (Throwable)e);
        }
    }
}

