/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.filter;

import com.xpn.xwiki.web.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.context.concurrent.ExecutionContextRunnable;
import org.xwiki.wysiwyg.converter.HTMLConverter;
import org.xwiki.wysiwyg.filter.MutableServletRequest;
import org.xwiki.wysiwyg.filter.MutableServletRequestFactory;

public class ConversionFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConversionFilter.class);
    private static final String REQUIRES_HTML_CONVERSION = "RequiresHTMLConversion";
    private static final String CONVERSION_OUTPUT = "com.xpn.xwiki.wysiwyg.server.converter.output";
    private static final String CONVERSION_ERRORS = "com.xpn.xwiki.wysiwyg.server.converter.errors";

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        String[] parametersRequiringHTMLConversion = req.getParameterValues(REQUIRES_HTML_CONVERSION);
        if (parametersRequiringHTMLConversion != null) {
            MutableServletRequestFactory mreqFactory = (MutableServletRequestFactory)Utils.getComponent(MutableServletRequestFactory.class);
            MutableServletRequest mreq = mreqFactory.newInstance(req);
            mreq.removeParameter(REQUIRES_HTML_CONVERSION);
            HashMap<String, Throwable> errors = new HashMap<String, Throwable>();
            HashMap<String, String> output = new HashMap<String, String>();
            this.convertHTMLWithExecutionContext(parametersRequiringHTMLConversion, mreq, output, errors);
            if (!errors.isEmpty()) {
                this.handleConversionErrors(errors, output, mreq, res);
            } else {
                chain.doFilter((ServletRequest)mreq, res);
            }
        } else {
            chain.doFilter(req, res);
        }
    }

    public void init(FilterConfig config) throws ServletException {
    }

    private void convertHTMLWithExecutionContext(final String[] parametersRequiringHTMLConversion, final MutableServletRequest request, final Map<String, String> output, final Map<String, Throwable> errors) {
        new ExecutionContextRunnable(new Runnable(){

            @Override
            public void run() {
                ConversionFilter.this.convertHTML(parametersRequiringHTMLConversion, request, output, errors);
            }
        }, Utils.getContextComponentManager()).run();
    }

    private void convertHTML(String[] parametersRequiringHTMLConversion, MutableServletRequest request, Map<String, String> output, Map<String, Throwable> errors) {
        for (int i = 0; i < parametersRequiringHTMLConversion.length; ++i) {
            String parameterName = parametersRequiringHTMLConversion[i];
            String html = request.getParameter(parameterName);
            String syntax = request.removeParameter(parameterName + "_syntax");
            if (html == null || syntax == null) continue;
            try {
                HTMLConverter converter = (HTMLConverter)Utils.getComponent(HTMLConverter.class);
                request.setParameter(parameterName, converter.fromHTML(html, syntax));
            }
            catch (Exception e) {
                LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
                errors.put(parameterName, e);
            }
            output.put(parameterName, request.getParameter(parameterName));
        }
    }

    private void handleConversionErrors(Map<String, Throwable> errors, Map<String, String> output, MutableServletRequest mreq, ServletResponse res) throws IOException {
        ServletRequest req = mreq.getRequest();
        if (req instanceof HttpServletRequest && "XMLHttpRequest".equals(((HttpServletRequest)req).getHeader("X-Requested-With"))) {
            StringBuilder errorMessage = new StringBuilder();
            for (Map.Entry<String, Throwable> entry : errors.entrySet()) {
                errorMessage.append(entry.getKey()).append(": ");
                errorMessage.append(entry.getValue().getLocalizedMessage()).append('\n');
            }
            ((HttpServletResponse)res).sendError(400, errorMessage.substring(0, errorMessage.length() - 1));
            return;
        }
        String redirectURL = mreq.getParameter("xerror");
        if (redirectURL == null) {
            redirectURL = mreq.getReferer();
        }
        String queryString = StringUtils.substringAfterLast((String)redirectURL, (String)String.valueOf('?'));
        redirectURL = StringUtils.substringBeforeLast((String)redirectURL, (String)String.valueOf('?'));
        if ((queryString = queryString.replaceAll("key=.*&?", "")).length() > 0 && !queryString.endsWith(String.valueOf('&'))) {
            queryString = queryString + '&';
        }
        queryString = queryString + "key=" + this.save(mreq, output, errors);
        mreq.sendRedirect(res, redirectURL + '?' + queryString);
    }

    private String save(MutableServletRequest mreq, Map<String, String> output, Map<String, Throwable> errors) {
        String key = RandomStringUtils.randomAlphanumeric((int)4);
        HashMap<String, Map<String, String>> conversionOutput = (HashMap<String, Map<String, String>>)mreq.getSessionAttribute(CONVERSION_OUTPUT);
        if (conversionOutput == null) {
            conversionOutput = new HashMap<String, Map<String, String>>();
            mreq.setSessionAttribute(CONVERSION_OUTPUT, conversionOutput);
        }
        conversionOutput.put(key, output);
        HashMap<String, Map<String, Throwable>> conversionErrors = (HashMap<String, Map<String, Throwable>>)mreq.getSessionAttribute(CONVERSION_ERRORS);
        if (conversionErrors == null) {
            conversionErrors = new HashMap<String, Map<String, Throwable>>();
            mreq.setSessionAttribute(CONVERSION_ERRORS, conversionErrors);
        }
        conversionErrors.put(key, errors);
        return key;
    }
}

