/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.internal.filter.http;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.xwiki.wysiwyg.filter.MutableServletRequest;

public class MutableHttpServletRequest
extends HttpServletRequestWrapper
implements MutableServletRequest {
    private final Map<String, String[]> params = new HashMap<String, String[]>();

    public MutableHttpServletRequest(HttpServletRequest request) {
        super(request);
        this.params.putAll(request.getParameterMap());
    }

    @Override
    public String setParameter(String name, String value) {
        String[] previousValues = this.params.put(name, new String[]{value});
        return previousValues == null || previousValues.length == 0 ? null : previousValues[0];
    }

    @Override
    public String[] setParameterValues(String name, String[] values) {
        return this.params.put(name, values);
    }

    @Override
    public String removeParameter(String name) {
        String[] previousValues = this.params.remove(name);
        return previousValues == null || previousValues.length == 0 ? null : previousValues[0];
    }

    public String getParameter(String name) {
        String[] values = this.params.get(name);
        return values == null || values.length == 0 ? null : values[0];
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.params);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.params.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.params.get(name);
    }

    @Override
    public void sendRedirect(ServletResponse res, String url) throws IOException {
        ((HttpServletResponse)res).sendRedirect(url);
    }

    @Override
    public String getReferer() {
        return this.getHeader("Referer");
    }

    @Override
    public Object getSessionAttribute(String attrName) {
        return this.getSession().getAttribute(attrName);
    }

    @Override
    public Object setSessionAttribute(String attrName, Object attrValue) {
        Object oldValue = this.getSession().getAttribute(attrName);
        this.getSession().setAttribute(attrName, attrValue);
        return oldValue;
    }
}

