/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client;

import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.MenuItemSeparator;
import com.google.gwt.user.client.ui.UIObject;
import java.util.List;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.wysiwyg.client.MenuItemDescriptor;
import org.xwiki.gwt.wysiwyg.client.MenuItemDescriptorJSONParser;
import org.xwiki.gwt.wysiwyg.client.plugin.PluginManager;
import org.xwiki.gwt.wysiwyg.client.plugin.UIExtension;

public class MenuBarController {
    public static final String MENU_ROLE = "menu";
    private final MenuBar menuBar;
    private final MenuItemDescriptorJSONParser menuItemDescriptorJSONParser = new MenuItemDescriptorJSONParser();

    public MenuBarController(MenuBar menuBar) {
        this.menuBar = menuBar;
    }

    public void fill(Config config, PluginManager pluginManager) {
        this.fillMenuBar(this.menuBar, this.menuItemDescriptorJSONParser.parse(config.getParameter(MENU_ROLE, "[]")), pluginManager);
    }

    private void fillMenuBar(MenuBar menuBar, List<MenuItemDescriptor> descriptors, PluginManager pluginManager) {
        for (MenuItemDescriptor descriptor : descriptors) {
            UIExtension uie = pluginManager.getUIExtension(MENU_ROLE, descriptor.getFeature());
            if (uie == null) continue;
            UIObject uiObject = uie.getUIObject(descriptor.getFeature());
            if (uiObject instanceof MenuItemSeparator) {
                menuBar.addSeparator((MenuItemSeparator)uiObject);
                continue;
            }
            if (!(uiObject instanceof MenuItem)) continue;
            MenuItem menuItem = (MenuItem)uiObject;
            if (!descriptor.getSubMenu().isEmpty()) {
                menuItem.setSubMenu(new MenuBar(true));
                this.fillMenuBar(menuItem.getSubMenu(), descriptor.getSubMenu(), pluginManager);
            }
            menuBar.addItem(menuItem);
        }
    }

    public void destroy() {
    }
}

