/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image;

import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.ui.UIObject;
import org.xwiki.gwt.user.client.ui.MenuItem;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImagePlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImagePluginFactory;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.MenuItemUIExtensionAdaptor;

public class ImageMenuExtension
extends MenuItemUIExtensionAdaptor {
    private MenuItem attachedImage;
    private MenuItem urlImage;
    private MenuItem edit;
    private MenuItem remove;
    private final ImagePlugin plugin;

    public ImageMenuExtension(final ImagePlugin plugin) {
        super("menu");
        this.plugin = plugin;
        this.attachedImage = this.createMenuItem(Strings.INSTANCE.imageInsertAttachedImage(), null, new com.google.gwt.user.client.Command(){

            public void execute() {
                plugin.onAttachedImage();
            }
        });
        if (Boolean.valueOf(plugin.getConfig().getParameter("allowExternalImages", "true")).booleanValue()) {
            this.urlImage = this.createMenuItem(Strings.INSTANCE.imageInsertURLImage(), null, new com.google.gwt.user.client.Command(){

                public void execute() {
                    plugin.onURLImage();
                }
            });
        }
        this.edit = this.createMenuItem(Strings.INSTANCE.imageEditImage(), null, new com.google.gwt.user.client.Command(){

            public void execute() {
                plugin.onImageEdit();
            }
        });
        this.remove = this.createMenuItem(Strings.INSTANCE.imageRemoveImage(), null, new com.google.gwt.user.client.Command(){

            public void execute() {
                plugin.onImageRemove();
            }
        });
        MenuItem imageMenu = this.createMenuItem(Strings.INSTANCE.image(), Images.INSTANCE.image());
        this.addFeature(ImagePluginFactory.getInstance().getPluginName(), (UIObject)imageMenu);
        this.addFeature("imageInsertAttached", (UIObject)this.attachedImage);
        if (this.urlImage != null) {
            this.addFeature("imageInsertURL", (UIObject)this.urlImage);
        }
        this.addFeature("imageEdit", (UIObject)this.edit);
        this.addFeature("imageRemove", (UIObject)this.remove);
    }

    protected void onAttach(AttachEvent event) {
        boolean editMode = this.plugin.getTextArea().getCommandManager().isExecuted(Command.INSERT_IMAGE);
        if (this.attachedImage.getParentMenu() == event.getSource()) {
            this.attachedImage.setEnabled(!editMode && this.plugin.getTextArea().getCommandManager().isEnabled(Command.INSERT_IMAGE));
            this.attachedImage.setVisible(!editMode);
        }
        if (this.urlImage != null && this.urlImage.getParentMenu() == event.getSource()) {
            this.urlImage.setEnabled(!editMode && this.plugin.getTextArea().getCommandManager().isEnabled(Command.INSERT_IMAGE));
            this.urlImage.setVisible(!editMode);
        }
        if (this.edit.getParentMenu() == event.getSource()) {
            this.edit.setEnabled(editMode);
            this.edit.setVisible(editMode);
        }
        if (this.remove.getParentMenu() == event.getSource()) {
            this.remove.setEnabled(editMode);
            this.remove.setVisible(editMode);
        }
    }
}

