/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.indent.exec;

import com.google.gwt.dom.client.Node;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.dom.client.Selection;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.AbstractSelectionExecutable;

public abstract class AbstractListExecutable
extends AbstractSelectionExecutable {
    protected static final String LIST_ITEM_TAG = "li";
    protected static final String UNORDERED_LIST_TAG = "ul";
    protected static final String ORDERED_LIST_TAG = "ol";

    public AbstractListExecutable(RichTextArea rta) {
        super(rta);
    }

    protected Element getListItem(Range range) {
        return (Element)this.domUtils.getFirstAncestor(range.getCommonAncestorContainer(), new String[]{LIST_ITEM_TAG});
    }

    protected boolean isList(Node node) {
        return node != null && (node.getNodeName().equalsIgnoreCase(ORDERED_LIST_TAG) || node.getNodeName().equalsIgnoreCase(UNORDERED_LIST_TAG));
    }

    public boolean execute(String param) {
        boolean executionResult = false;
        Selection selection = this.rta.getDocument().getSelection();
        Range range = selection.getRangeAt(0);
        if (range.isCollapsed()) {
            Element listItem = this.getListItem(range);
            if (this.canExecute(listItem)) {
                this.execute(listItem);
                executionResult = true;
            }
        } else {
            executionResult = this.executeOnMultipleItems(range, true);
        }
        selection.removeAllRanges();
        selection.addRange(range);
        return executionResult;
    }

    protected abstract void execute(Element var1);

    protected boolean canExecute(Element listItem) {
        return listItem != null;
    }

    protected abstract boolean executeOnMultipleItems(Range var1, boolean var2);

    public boolean isEnabled() {
        if (!super.isEnabled()) {
            return false;
        }
        Range range = this.rta.getDocument().getSelection().getRangeAt(0);
        if (range.isCollapsed()) {
            Element listItem = this.getListItem(range);
            return this.canExecute(listItem);
        }
        return this.executeOnMultipleItems(range, false);
    }
}

