/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link;

import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfigJSONParser;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfigJSONParser;

public class LinkConfigFactory {
    private final RichTextArea rta;
    private final LinkConfigJSONParser linkConfigJSONParser = new LinkConfigJSONParser();
    private final ImageConfigJSONParser imageConfigJSONParser = new ImageConfigJSONParser();

    public LinkConfigFactory(RichTextArea rta) {
        this.rta = rta;
    }

    public LinkConfig createLinkConfig() {
        String linkJSON = this.rta.getCommandManager().getStringValue(Command.CREATE_LINK);
        if (linkJSON != null) {
            return this.linkConfigJSONParser.parse(linkJSON);
        }
        LinkConfig linkConfig = new LinkConfig();
        Range range = this.rta.getDocument().getSelection().getRangeAt(0);
        linkConfig.setLabel(range.toHTML());
        String imageJSON = this.rta.getCommandManager().getStringValue(Command.INSERT_IMAGE);
        if (imageJSON != null) {
            linkConfig.setLabelText(this.imageConfigJSONParser.parse(imageJSON).getReference());
            linkConfig.setReadOnlyLabel(true);
        } else {
            linkConfig.setLabelText(range.toString());
        }
        return linkConfig;
    }
}

