/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.smartgwt.client.widgets.events.KeyPressEvent;
import com.smartgwt.client.widgets.events.KeyPressHandler;
import com.smartgwt.client.widgets.grid.events.RecordDoubleClickEvent;
import com.smartgwt.client.widgets.grid.events.RecordDoubleClickHandler;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.VerticalResizePanel;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListenerCollection;
import org.xwiki.gwt.user.client.ui.wizard.SourcesNavigationEvents;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.widget.explorer.XWikiExplorer;
import org.xwiki.gwt.wysiwyg.client.widget.explorer.ds.WikiDataSource;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AbstractSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.AttachmentReference;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.ResourceReference;

public abstract class AbstractExplorerWizardStep
extends AbstractSelectorWizardStep<EntityLink<LinkConfig>>
implements SourcesNavigationEvents,
RecordDoubleClickHandler,
KeyPressHandler {
    protected static final String FIELD_ERROR_STYLE = "xErrorField";
    private final XWikiExplorer explorer = new XWikiExplorer();
    private final Label errorLabel = new Label();
    private final Label helpLabel = new Label();
    private final NavigationListenerCollection listeners = new NavigationListenerCollection();

    public AbstractExplorerWizardStep(boolean addPage, boolean showAttachments, boolean addAttachments) {
        this(addPage, showAttachments, addAttachments, 455, 305);
    }

    protected AbstractExplorerWizardStep(boolean addPage, boolean showAttachments, boolean addAttachments, int width, int height) {
        super((FlowPanel)new VerticalResizePanel());
        this.explorer.setDisplayLinks(false);
        this.explorer.setDisplayAddPage(addPage);
        this.explorer.setDisplayAddPageOnTop(true);
        this.explorer.setDisplayAttachments(showAttachments);
        this.explorer.setDisplayAddAttachment(showAttachments && addAttachments);
        this.explorer.setDisplayAddAttachmentOnTop(true);
        this.explorer.setDisplayAttachmentsWhenEmpty(showAttachments && addAttachments);
        String sizeUnit = "px";
        this.explorer.setWidth(width + sizeUnit);
        this.explorer.setHeight(height + sizeUnit);
        WikiDataSource ds = new WikiDataSource();
        this.explorer.setDataSource(ds);
        this.explorer.setDefaultValue("");
        this.explorer.getElement().setClassName(this.explorer.getElement().getClassName() + " xExplorer");
        this.explorer.addRecordDoubleClickHandler(this);
        this.explorer.addKeyPressHandler(this);
        this.helpLabel.addStyleName("xHelpLabel");
        this.display().add((Widget)this.helpLabel);
        this.errorLabel.setVisible(false);
        this.errorLabel.addStyleName("xErrorMsg");
        this.display().add((Widget)this.errorLabel);
        this.display().addStyleName("xExplorerPanel");
        this.display().add((Widget)this.explorer);
        this.display().setExpandingWidget((Widget)this.explorer, true);
    }

    public void setHelpLabelText(String helpLabelText) {
        this.helpLabel.setText(helpLabelText);
    }

    protected void invalidateExplorerData() {
        try {
            this.explorer.invalidateCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public VerticalResizePanel display() {
        return (VerticalResizePanel)super.display();
    }

    public XWikiExplorer getExplorer() {
        return this.explorer;
    }

    @Override
    public void init(Object data, AsyncCallback<?> cb) {
        this.hideError();
        super.init(data, cb);
    }

    @Override
    protected void initializeSelection(AsyncCallback<?> initCallback) {
        EntityReference targetEntityReference = ((EntityLink)this.getData()).getDestination().getEntityReference();
        if (StringUtils.isEmpty((String)this.getExplorer().getValue()) || !((EntityLink)this.getData()).getOrigin().equals(targetEntityReference)) {
            boolean isAttachment = ((EntityLink)this.getData()).getDestination().getType() == ResourceReference.ResourceType.ATTACHMENT;
            String fileName = new AttachmentReference(targetEntityReference).getFileName();
            String anchor = isAttachment && StringUtils.isEmpty((String)fileName) ? "Attachments" : null;
            this.getExplorer().selectEntity(targetEntityReference, anchor);
        }
        super.initializeSelection(initCallback);
    }

    protected void displayError(String errorMessage) {
        this.errorLabel.setText(errorMessage);
        this.errorLabel.setVisible(true);
        if (!this.explorer.getElement().getClassName().contains(FIELD_ERROR_STYLE)) {
            this.explorer.getElement().setClassName(this.explorer.getElement().getClassName() + " " + FIELD_ERROR_STYLE);
        }
        this.display().refreshHeights();
    }

    protected void hideError() {
        this.errorLabel.setVisible(false);
        String boundary = "\\b";
        this.explorer.getElement().setClassName(this.explorer.getElement().getClassName().replaceAll(boundary + FIELD_ERROR_STYLE + boundary, ""));
        this.display().refreshHeights();
    }

    public void addNavigationListener(NavigationListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void onRecordDoubleClick(RecordDoubleClickEvent event) {
        this.listeners.fireNavigationEvent(NavigationListener.NavigationDirection.NEXT);
    }

    public void onKeyPress(KeyPressEvent event) {
        if ("Enter".equals(event.getKeyName())) {
            this.listeners.fireNavigationEvent(NavigationListener.NavigationDirection.NEXT);
        }
    }

    protected void updateLinkConfig(EntityReference selectedEntityReference) {
        ((EntityLink)this.getData()).getDestination().setEntityReference(selectedEntityReference.clone());
        ((LinkConfig)((EntityLink)this.getData()).getData()).setReference(null);
        ((LinkConfig)((EntityLink)this.getData()).getData()).setUrl(null);
    }

    public void onCancel() {
    }
}

