/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro.input;

import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.TextBoxBase;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.ParameterType;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.input.ChoiceInput;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.input.TextInput;

public final class InputFactory {
    private InputFactory() {
    }

    public static Widget createInput(ParameterType type) {
        String className = type.getName();
        if ("java.lang.StringBuffer".equals(className)) {
            return new TextInput((TextBoxBase)new TextArea());
        }
        if ("boolean".equals(className) || "java.lang.Boolean".equals(className)) {
            return InputFactory.createBooleanInput();
        }
        if (type.isEnum()) {
            return InputFactory.createChoiceInput(type.getEnumConstants());
        }
        TextInput input = new TextInput((TextBoxBase)new TextBox());
        input.addStyleName("textInput");
        return input;
    }

    protected static ChoiceInput createChoiceInput(Map<String, String> options) {
        ListBox list = new ListBox();
        for (Map.Entry<String, String> option : options.entrySet()) {
            list.addItem(option.getValue(), option.getKey());
        }
        return new ChoiceInput(list);
    }

    protected static ChoiceInput createBooleanInput() {
        ListBox list = new ListBox();
        list.addItem(Strings.INSTANCE.yes(), String.valueOf(true));
        list.addItem(Strings.INSTANCE.no(), String.valueOf(false));
        return new ChoiceInput(list);
    }
}

