/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.readonly;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import java.util.Arrays;
import java.util.List;
import org.xwiki.gwt.dom.client.PasteEvent;
import org.xwiki.gwt.dom.client.PasteHandler;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandListener;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandManager;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.readonly.ReadOnlyKeyboardHandler;
import org.xwiki.gwt.wysiwyg.client.plugin.readonly.ReadOnlyUtils;

public class ReadOnlyPlugin
extends AbstractPlugin
implements CommandListener,
PasteHandler {
    private static final List<Command> ALLOWED_COMMANDS = Arrays.asList(Command.ENABLE, Command.REDO, Command.RESET, new Command("submit"), Command.UNDO, Command.UPDATE, MacroPlugin.REFRESH, MacroPlugin.COLLAPSE, MacroPlugin.EXPAND, MacroPlugin.INSERT);
    private final ReadOnlyKeyboardHandler keyboardHandler = (ReadOnlyKeyboardHandler)((Object)GWT.create(ReadOnlyKeyboardHandler.class));
    private final ReadOnlyUtils readOnlyUtils = new ReadOnlyUtils();

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        this.saveRegistration(this.getTextArea().addKeyDownHandler((KeyDownHandler)this.keyboardHandler));
        this.saveRegistration(this.getTextArea().addKeyPressHandler((KeyPressHandler)this.keyboardHandler));
        this.saveRegistration(this.getTextArea().addKeyUpHandler((KeyUpHandler)this.keyboardHandler));
        this.saveRegistration(this.getTextArea().addPasteHandler((PasteHandler)this));
        this.getTextArea().getCommandManager().addCommandListener((CommandListener)this);
    }

    public void destroy() {
        this.getTextArea().getCommandManager().removeCommandListener((CommandListener)this);
        super.destroy();
    }

    public boolean onBeforeCommand(CommandManager sender, Command command, String param) {
        return !ALLOWED_COMMANDS.contains(command) && this.readOnlyUtils.isSelectionBoundaryInsideReadOnlyElement(this.getTextArea().getDocument());
    }

    public void onCommand(CommandManager sender, Command command, String param) {
    }

    public void onPaste(PasteEvent event) {
        if (this.readOnlyUtils.isSelectionBoundaryInsideReadOnlyElement(this.getTextArea().getDocument())) {
            event.preventDefault();
        }
    }
}

