/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.style;

import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONBoolean;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xwiki.gwt.wysiwyg.client.plugin.style.StyleDescriptor;

public class StyleDescriptorJSONParser {
    public List<StyleDescriptor> parse(String json) {
        JSONArray jsDescriptors = JSONParser.parseStrict((String)json).isArray();
        if (jsDescriptors == null) {
            return Collections.emptyList();
        }
        ArrayList<StyleDescriptor> descriptors = new ArrayList<StyleDescriptor>();
        for (int i = 0; i < jsDescriptors.size(); ++i) {
            StyleDescriptor descriptor;
            JSONObject jsDescriptor = jsDescriptors.get(i).isObject();
            if (jsDescriptor == null || (descriptor = this.createStyleDescriptor(jsDescriptor)) == null) continue;
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    private StyleDescriptor createStyleDescriptor(JSONObject jsDescriptor) {
        JSONValue oName = jsDescriptor.get("name");
        if (oName == null) {
            return null;
        }
        JSONString sName = oName.isString();
        if (sName == null) {
            return null;
        }
        String name = sName.stringValue().trim();
        if (name.length() == 0) {
            return null;
        }
        JSONValue oLabel = jsDescriptor.get("label");
        JSONString sLabel = oLabel != null ? oLabel.isString() : null;
        String label = sLabel != null ? sLabel.stringValue().trim() : name;
        JSONValue inline = jsDescriptor.get("inline");
        JSONBoolean bInline = inline != null ? inline.isBoolean() : null;
        return new StyleDescriptor(name, label, bInline != null ? bInline.booleanValue() : true);
    }
}

