/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.table.feature;

import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.ui.Image;
import java.util.EnumSet;
import org.xwiki.gwt.dom.client.Document;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.dom.client.Selection;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.InsertBlockHTMLExecutable;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.Wizard;
import org.xwiki.gwt.user.client.ui.wizard.WizardListener;
import org.xwiki.gwt.user.client.ui.wizard.WizardStepMap;
import org.xwiki.gwt.user.client.ui.wizard.WizardStepProvider;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.table.TableDescriptor;
import org.xwiki.gwt.wysiwyg.client.plugin.table.TablePlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.table.feature.AbstractTableFeature;
import org.xwiki.gwt.wysiwyg.client.plugin.table.ui.TableConfigWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.table.util.TableConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.table.util.TableUtils;

public class InsertTable
extends AbstractTableFeature
implements WizardListener {
    public static final String NAME = "inserttable";
    private static final String CONFIG_STEP_NAME = "config";
    private Wizard wizard;
    private final InsertBlockHTMLExecutable insertBlockHTMLExecutable;

    public InsertTable(TablePlugin plugin) {
        super(NAME, new Command(NAME), Strings.INSTANCE.insertTable(), plugin);
        this.insertBlockHTMLExecutable = new InsertBlockHTMLExecutable(this.rta);
    }

    public Wizard getWizard() {
        if (this.wizard == null) {
            TableConfigWizardStep configStep = new TableConfigWizardStep();
            configStep.setDirectionName(NavigationListener.NavigationDirection.FINISH, Strings.INSTANCE.tableInsertButton());
            configStep.setValidDirections(EnumSet.of(NavigationListener.NavigationDirection.FINISH));
            WizardStepMap insertSteps = new WizardStepMap();
            insertSteps.put((Object)CONFIG_STEP_NAME, (Object)configStep);
            this.wizard = new Wizard(Strings.INSTANCE.tableInsertDialogCaption(), new Image(Images.INSTANCE.insertTable()));
            this.wizard.setProvider((WizardStepProvider)insertSteps);
            this.wizard.addWizardListener((WizardListener)this);
        }
        return this.wizard;
    }

    public Element createTable(Document doc, TableConfig config) {
        int i;
        StringBuffer table = new StringBuffer("<table>");
        StringBuffer row = new StringBuffer("<tr>");
        for (i = 0; i < config.getColNumber(); ++i) {
            row.append("<td>");
            row.append("&nbsp;");
            row.append("</td>");
        }
        row.append("</tr>");
        if (config.hasHeader()) {
            table.append("<thead>");
            if (config.getRowNumber() > 0) {
                table.append(row.toString().replace("td", "th"));
            }
            table.append("</thead>");
        }
        table.append("<tbody>");
        int n = i = config.hasHeader() ? 1 : 0;
        while (i < config.getRowNumber()) {
            table.append(row.toString());
            ++i;
        }
        table.append("</tbody></table>");
        Element container = (Element)doc.createDivElement().cast();
        container.setInnerHTML(table.toString());
        Element tableElement = (Element)container.getFirstChild();
        container.removeChild((Node)tableElement);
        return tableElement;
    }

    public void insertTable(TableConfig config) {
        Element table = this.createTable(this.rta.getDocument(), config);
        this.insertBlockHTMLExecutable.execute((Node)table);
        Range range = this.rta.getDocument().createRange();
        range.selectNodeContents(this.domUtils.getFirstDescendant((Node)table, config.hasHeader() ? "TH" : "TD"));
        range.collapse(true);
        Selection selection = this.rta.getDocument().getSelection();
        selection.removeAllRanges();
        selection.addRange(range);
    }

    public boolean execute(String parameter) {
        if (StringUtils.isEmpty((String)parameter)) {
            this.getWizard().start(CONFIG_STEP_NAME, null);
        } else {
            this.insertTable((TableConfig)TableConfig.fromJson((String)parameter));
        }
        return true;
    }

    public boolean isEnabled() {
        return super.isEnabled() && TableUtils.getInstance().getTable(TableUtils.getInstance().getCaretNode(this.rta.getDocument())) == null;
    }

    public void onCancel(Wizard sender) {
        if (sender == this.getWizard()) {
            this.getPlugin().getTextArea().setFocus(true);
        }
    }

    public void onFinish(Wizard sender, Object result) {
        if (sender == this.getWizard()) {
            this.getPlugin().getTextArea().setFocus(true);
            TableDescriptor descriptor = (TableDescriptor)result;
            this.getPlugin().getTextArea().getCommandManager().execute(this.getCommand(), "{ rows:" + descriptor.getRowCount() + ", cols: " + descriptor.getColumnCount() + ", header: " + descriptor.isWithHeader() + " }");
        }
    }
}

